/*
 * Decompiled with CFR 0.152.
 */
package com.targomo.client.api.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.targomo.client.api.TravelOptions;
import com.targomo.client.api.exception.TargomoClientRuntimeException;
import java.util.Map;
import org.json.JSONObject;

public class PointOfInterestSummaryResponse {
    private final TravelOptions travelOptions;
    private final JSONObject result;
    private final long requestEnd;
    private POISummary summary;

    public PointOfInterestSummaryResponse(TravelOptions travelOptions, JSONObject result, long requestStart) {
        this.travelOptions = travelOptions;
        this.requestEnd = System.currentTimeMillis() - requestStart;
        this.result = result;
        this.parseResultResults();
    }

    public void parseResultResults() {
        try {
            this.summary = (POISummary)new ObjectMapper().readValue(this.result.toString(), POISummary.class);
        }
        catch (JsonProcessingException e) {
            throw new TargomoClientRuntimeException("Couldn't parse POI reachability summary response", e);
        }
    }

    public TravelOptions getTravelOptions() {
        return this.travelOptions;
    }

    public JSONObject getResult() {
        return this.result;
    }

    public long getRequestEnd() {
        return this.requestEnd;
    }

    public POISummary getSummary() {
        return this.summary;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class POISummary {
        private int totalPoi;
        private Map<String, Integer> osmTypesCount;
        private Map<String, Integer> groupIdCount;
        private Map<String, Integer> clusterIdCount;

        public void setTotalPoi(int totalPoi) {
            this.totalPoi = totalPoi;
        }

        public void setOsmTypesCount(Map<String, Integer> osmTypesCount) {
            this.osmTypesCount = osmTypesCount;
        }

        public void setGroupIdCount(Map<String, Integer> groupIdCount) {
            this.groupIdCount = groupIdCount;
        }

        public void setClusterIdCount(Map<String, Integer> clusterIdCount) {
            this.clusterIdCount = clusterIdCount;
        }

        public int getTotalPoi() {
            return this.totalPoi;
        }

        public Map<String, Integer> getOsmTypesCount() {
            return this.osmTypesCount;
        }

        public Map<String, Integer> getGroupIdCount() {
            return this.groupIdCount;
        }

        public Map<String, Integer> getClusterIdCount() {
            return this.clusterIdCount;
        }

        public String toString() {
            return "PointOfInterestSummaryResponse.POISummary(totalPoi=" + this.getTotalPoi() + ", osmTypesCount=" + this.getOsmTypesCount() + ", groupIdCount=" + this.getGroupIdCount() + ", clusterIdCount=" + this.getClusterIdCount() + ")";
        }
    }
}

