/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.mantisapi;

import com.taskadapter.mantisapi.RequiredItemException;
import com.taskadapter.mantisapi.beans.AccountData;
import com.taskadapter.mantisapi.beans.FilterData;
import com.taskadapter.mantisapi.beans.IssueData;
import com.taskadapter.mantisapi.beans.IssueHeaderData;
import com.taskadapter.mantisapi.beans.ProjectData;
import com.taskadapter.mantisapi.beans.RelationshipData;
import com.taskadapter.mantisapi.internal.MantisConnectLocator;
import com.taskadapter.mantisapi.internal.MantisConnectPortType;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MantisManager {
    private static final boolean PRINT_DEBUG = false;
    private static final int DEFAULT_ITEMS_PER_PAGE = 25;
    private String host;
    private String login;
    private String password;
    private int itemsPerPage = 25;
    private MantisConnectPortType connector = null;

    private MantisConnectPortType getConnector() {
        if (this.connector == null) {
            MantisConnectLocator locator = new MantisConnectLocator();
            locator.setMantisConnectPortEndpointAddress(this.host + "/api/soap/mantisconnect.php");
            this.connector = locator.getMantisConnectPort();
        }
        return this.connector;
    }

    public MantisManager(String uri) {
        if (uri == null || uri.isEmpty()) {
            throw new IllegalArgumentException("The host parameter is NULL or empty");
        }
        this.host = uri;
    }

    public MantisManager(String uri, String login, String password) {
        this(uri);
        this.login = login;
        this.password = password;
    }

    public String getVersion() throws RemoteException {
        return this.getConnector().mc_version();
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public void setItemsPerPage(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    public List<ProjectData> getProjects() throws RemoteException {
        return new ArrayList<ProjectData>(Arrays.asList(this.getConnector().mc_projects_get_user_accessible(this.login, this.password)));
    }

    public ProjectData getProjectById(BigInteger projectId) throws RemoteException {
        if (projectId.intValue() > 0) {
            List<ProjectData> projectList = this.getProjects();
            for (ProjectData project : projectList) {
                if (!project.getId().equals(projectId)) continue;
                return project;
            }
        }
        return null;
    }

    public BigInteger createProject(ProjectData project) throws RemoteException, RequiredItemException {
        if (project.getName() == "" || project.getName() == null) {
            throw new RequiredItemException("Required property Name is empty");
        }
        BigInteger newId = this.getConnector().mc_project_add(this.login, this.password, project);
        project.setId(newId);
        return newId;
    }

    public boolean deleteProject(BigInteger projectId) throws RemoteException {
        return this.getConnector().mc_project_delete(this.login, this.password, projectId);
    }

    public List<IssueHeaderData> getIssuesHeadersByProject(BigInteger projectId) throws RemoteException {
        ArrayList<IssueHeaderData> issuesHeaders = new ArrayList<IssueHeaderData>();
        if (projectId.intValue() > 0) {
            int pageNumber = 1;
            ArrayList<Object> lastItems = new ArrayList<Object>();
            while (true) {
                List<Object> foundItems = new ArrayList();
                foundItems = Arrays.asList(this.getConnector().mc_project_get_issue_headers(this.login, this.password, projectId, new BigInteger(String.valueOf(pageNumber)), BigInteger.valueOf(this.itemsPerPage)));
                if (lastItems.equals(foundItems)) break;
                lastItems.clear();
                lastItems.addAll(foundItems);
                issuesHeaders.addAll(foundItems);
                if (foundItems.size() == 0 || foundItems.size() != this.itemsPerPage) break;
                ++pageNumber;
            }
        }
        return issuesHeaders;
    }

    public List<IssueData> getIssuesByProject(BigInteger projectId) throws RemoteException {
        ArrayList<IssueData> issues = new ArrayList<IssueData>();
        if (projectId.intValue() > 0) {
            int pageNumber = 1;
            ArrayList<Object> lastItems = new ArrayList<Object>();
            while (true) {
                List<Object> foundItems = new ArrayList();
                foundItems = Arrays.asList(this.getConnector().mc_project_get_issues(this.login, this.password, projectId, new BigInteger(String.valueOf(pageNumber)), BigInteger.valueOf(this.itemsPerPage)));
                if (lastItems.equals(foundItems)) break;
                lastItems.clear();
                lastItems.addAll(foundItems);
                issues.addAll(foundItems);
                if (foundItems.size() == 0 || foundItems.size() != this.itemsPerPage) break;
                ++pageNumber;
            }
        }
        return issues;
    }

    public List<IssueData> getIssuesByFilter(BigInteger projectId, BigInteger filterId) throws RemoteException {
        ArrayList<IssueData> issues = new ArrayList<IssueData>();
        if (projectId.intValue() > 0) {
            int pageNumber = 1;
            ArrayList<Object> lastItems = new ArrayList<Object>();
            while (true) {
                List<Object> foundItems = new ArrayList();
                foundItems = Arrays.asList(this.getConnector().mc_filter_get_issues(this.login, this.password, projectId, filterId, new BigInteger(String.valueOf(pageNumber)), BigInteger.valueOf(this.itemsPerPage)));
                if (lastItems.equals(foundItems)) break;
                lastItems.clear();
                lastItems.addAll(foundItems);
                issues.addAll(foundItems);
                if (foundItems.size() == 0 || foundItems.size() != this.itemsPerPage) break;
                ++pageNumber;
            }
        }
        return issues;
    }

    public IssueData getIssueById(BigInteger issueId) throws RemoteException {
        return this.getConnector().mc_issue_get(this.login, this.password, issueId);
    }

    public IssueData getIssueBySummary(String summary) throws RemoteException {
        IssueData issue = null;
        BigInteger issueId = this.getConnector().mc_issue_get_id_from_summary(this.login, this.password, summary);
        if (issueId.intValue() > 0) {
            issue = this.getIssueById(issueId);
        }
        return issue;
    }

    public BigInteger createIssue(IssueData issue) throws RemoteException, RequiredItemException {
        if (issue.getSummary() == "" || issue.getSummary() == null) {
            throw new RequiredItemException("Required property Summary is empty");
        }
        if (issue.getCategory() == "" || issue.getCategory() == null) {
            issue.setCategory("General");
        }
        if (issue.getDescription() == "" || issue.getDescription() == null) {
            throw new RequiredItemException("Required property Description is empty");
        }
        BigInteger newId = this.getConnector().mc_issue_add(this.login, this.password, issue);
        issue.setId(newId);
        return newId;
    }

    public boolean updateIssue(BigInteger issueId, IssueData issue) throws RemoteException {
        return this.getConnector().mc_issue_update(this.login, this.password, issueId, issue);
    }

    public boolean deleteIssue(BigInteger issueId) throws RemoteException {
        return this.getConnector().mc_issue_delete(this.login, this.password, issueId);
    }

    public BigInteger createRelationship(BigInteger issueId, RelationshipData relation) throws RemoteException {
        BigInteger id = this.getConnector().mc_issue_relationship_add(this.login, this.password, issueId, relation);
        relation.setId(id);
        return id;
    }

    public boolean deleteRelationship(BigInteger issueId, BigInteger relationshipId) throws RemoteException {
        return this.getConnector().mc_issue_relationship_delete(this.login, this.password, issueId, relationshipId);
    }

    public List<AccountData> getUsers() throws RemoteException {
        return new ArrayList<AccountData>(Arrays.asList(this.getConnector().mc_project_get_users(this.login, this.password, new BigInteger("0"), new BigInteger("0"))));
    }

    public AccountData getUserById(BigInteger userId) throws RemoteException {
        if (userId.intValue() > 0) {
            List<AccountData> userList = this.getUsers();
            for (AccountData user : userList) {
                if (!user.getId().equals(userId)) continue;
                return user;
            }
        }
        return null;
    }

    public AccountData getCurrentUser() throws RemoteException {
        if (this.login.length() > 0 && this.login != null) {
            List<AccountData> userList = this.getUsers();
            for (AccountData user : userList) {
                if (!user.getName().equals(this.login)) continue;
                return user;
            }
        }
        return null;
    }

    private static void debug(String string) {
    }

    public FilterData[] getFilters(BigInteger projectId) throws RemoteException {
        return this.getConnector().mc_filter_get(this.login, this.password, projectId);
    }
}

