/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi;

import com.taskadapter.redmineapi.NotFoundException;
import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineInternalError;
import com.taskadapter.redmineapi.RedmineOptions;
import com.taskadapter.redmineapi.bean.Attachment;
import com.taskadapter.redmineapi.bean.Group;
import com.taskadapter.redmineapi.bean.Identifiable;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.IssuePriority;
import com.taskadapter.redmineapi.bean.IssueRelation;
import com.taskadapter.redmineapi.bean.IssueStatus;
import com.taskadapter.redmineapi.bean.Membership;
import com.taskadapter.redmineapi.bean.News;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Role;
import com.taskadapter.redmineapi.bean.SavedQuery;
import com.taskadapter.redmineapi.bean.TimeEntry;
import com.taskadapter.redmineapi.bean.TimeEntryActivity;
import com.taskadapter.redmineapi.bean.Tracker;
import com.taskadapter.redmineapi.bean.User;
import com.taskadapter.redmineapi.bean.Version;
import com.taskadapter.redmineapi.bean.Watcher;
import com.taskadapter.redmineapi.internal.CopyBytesHandler;
import com.taskadapter.redmineapi.internal.Joiner;
import com.taskadapter.redmineapi.internal.Transport;
import com.taskadapter.redmineapi.internal.URIConfigurator;
import com.taskadapter.redmineapi.internal.io.MarkedIOException;
import com.taskadapter.redmineapi.internal.io.MarkedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class RedmineManager {
    private final Transport transport;

    public RedmineManager(String uri) {
        this(uri, RedmineOptions.simpleOptions());
    }

    public RedmineManager(String uri, String login, String password) {
        this(uri, login, password, RedmineOptions.simpleOptions());
    }

    public RedmineManager(String host, String apiAccessKey) {
        this(host, apiAccessKey, RedmineOptions.simpleOptions());
    }

    public RedmineManager(String host, String apiAccessKey, RedmineOptions options) {
        this.transport = new Transport(new URIConfigurator(host, apiAccessKey), options);
    }

    public RedmineManager(String uri, RedmineOptions options) {
        this(uri, null, null, options);
    }

    public RedmineManager(String uri, String login, String password, RedmineOptions options) {
        this.transport = new Transport(new URIConfigurator(uri, null), options);
        this.transport.setCredentials(login, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Issue createIssue(String projectKey, Issue issue) throws RedmineException {
        Project oldProject = issue.getProject();
        Project newProject = new Project();
        newProject.setIdentifier(projectKey);
        issue.setProject(newProject);
        try {
            Issue issue2 = this.transport.addObject(issue, new NameValuePair[]{new BasicNameValuePair("include", INCLUDE.attachments.toString())});
            return issue2;
        }
        finally {
            issue.setProject(oldProject);
        }
    }

    public List<Project> getProjects() throws RedmineException {
        try {
            return this.transport.getObjectsList(Project.class, new NameValuePair[]{new BasicNameValuePair("include", "trackers")});
        }
        catch (NotFoundException e) {
            throw new RedmineInternalError("NotFoundException received, which should never happen in this request");
        }
    }

    public List<Issue> getIssuesBySummary(String projectKey, String summaryField) throws RedmineException {
        if (projectKey != null && projectKey.length() > 0) {
            return this.transport.getObjectsList(Issue.class, new NameValuePair[]{new BasicNameValuePair("subject", summaryField), new BasicNameValuePair("project_id", projectKey)});
        }
        return this.transport.getObjectsList(Issue.class, new NameValuePair[]{new BasicNameValuePair("subject", summaryField)});
    }

    public List<Issue> getIssues(Map<String, String> pParameters) throws RedmineException {
        HashSet<BasicNameValuePair> params = new HashSet<BasicNameValuePair>();
        for (Map.Entry<String, String> param : pParameters.entrySet()) {
            params.add(new BasicNameValuePair(param.getKey(), param.getValue()));
        }
        return this.transport.getObjectsList(Issue.class, params);
    }

    public Issue getIssueById(Integer id, INCLUDE ... include) throws RedmineException {
        String value = Joiner.join(",", include);
        return this.transport.getObject(Issue.class, id, new NameValuePair[]{new BasicNameValuePair("include", value)});
    }

    public Project getProjectByKey(String projectKey) throws RedmineException {
        return this.transport.getObject(Project.class, projectKey, new NameValuePair[]{new BasicNameValuePair("include", "trackers")});
    }

    public void deleteProject(String projectKey) throws RedmineException {
        this.transport.deleteObject(Project.class, projectKey);
    }

    public void deleteIssue(Integer id) throws RedmineException {
        this.transport.deleteObject(Issue.class, Integer.toString(id));
    }

    public List<Issue> getIssues(String projectKey, Integer queryId, INCLUDE ... include) throws RedmineException {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        if (queryId != null) {
            params.add(new BasicNameValuePair("query_id", String.valueOf(queryId)));
        }
        if (projectKey != null && projectKey.length() > 0) {
            params.add(new BasicNameValuePair("project_id", projectKey));
        }
        String includeStr = Joiner.join(",", include);
        params.add(new BasicNameValuePair("include", includeStr));
        return this.transport.getObjectsList(Issue.class, params);
    }

    public void update(Identifiable obj) throws RedmineException {
        this.validate(obj);
        this.transport.updateObject(obj, new NameValuePair[0]);
    }

    private void validate(Identifiable obj) {
        if (obj instanceof TimeEntry && !((TimeEntry)obj).isValid()) {
            throw this.createIllegalTimeEntryException();
        }
    }

    public Project createProject(Project project) throws RedmineException {
        return this.transport.addObject(project, new NameValuePair[]{new BasicNameValuePair("include", "trackers")});
    }

    public int getObjectsPerPage() {
        return this.transport.getObjectsPerPage();
    }

    public void setObjectsPerPage(int pageSize) {
        this.transport.setObjectsPerPage(pageSize);
    }

    public List<User> getUsers() throws RedmineException {
        return this.transport.getObjectsList(User.class, new NameValuePair[]{new BasicNameValuePair("include", "memberships,groups")});
    }

    public User getUserById(Integer userId) throws RedmineException {
        return this.transport.getObject(User.class, userId, new NameValuePair[]{new BasicNameValuePair("include", "memberships,groups")});
    }

    public User getCurrentUser() throws RedmineException {
        return this.transport.getCurrentUser(new NameValuePair[0]);
    }

    public User createUser(User user) throws RedmineException {
        return this.transport.addObject(user, new NameValuePair[0]);
    }

    public void deleteUser(Integer userId) throws RedmineException {
        this.transport.deleteObject(User.class, Integer.toString(userId));
    }

    public List<Group> getGroups() throws RedmineException {
        return this.transport.getObjectsList(Group.class, new NameValuePair[0]);
    }

    public Group getGroupById(int id) throws RedmineException {
        return this.transport.getObject(Group.class, id, new NameValuePair[0]);
    }

    public Group getGroupByName(String name) throws RedmineException {
        return this.transport.getObject(Group.class, name, new NameValuePair[0]);
    }

    public Group createGroup(Group base) throws RedmineException {
        return this.transport.addObject(base, new NameValuePair[0]);
    }

    public void deleteGroup(Group base) throws RedmineException {
        this.transport.deleteObject(Group.class, base.getId().toString());
    }

    public List<TimeEntry> getTimeEntries() throws RedmineException {
        return this.transport.getObjectsList(TimeEntry.class, new NameValuePair[0]);
    }

    public TimeEntry getTimeEntry(Integer id) throws RedmineException {
        return this.transport.getObject(TimeEntry.class, id, new NameValuePair[0]);
    }

    public List<TimeEntry> getTimeEntriesForIssue(Integer issueId) throws RedmineException {
        return this.transport.getObjectsList(TimeEntry.class, new NameValuePair[]{new BasicNameValuePair("issue_id", Integer.toString(issueId))});
    }

    public TimeEntry createTimeEntry(TimeEntry obj) throws RedmineException {
        this.validate(obj);
        return this.transport.addObject(obj, new NameValuePair[0]);
    }

    public void deleteTimeEntry(Integer id) throws RedmineException {
        this.transport.deleteObject(TimeEntry.class, Integer.toString(id));
    }

    private IllegalArgumentException createIllegalTimeEntryException() {
        return new IllegalArgumentException("You have to either define a Project or Issue ID for a Time Entry. The given Time Entry object has neither defined.");
    }

    public List<SavedQuery> getSavedQueries(String projectKey) throws RedmineException {
        HashSet<BasicNameValuePair> params = new HashSet<BasicNameValuePair>();
        if (projectKey != null && projectKey.length() > 0) {
            params.add(new BasicNameValuePair("project_id", projectKey));
        }
        return this.transport.getObjectsList(SavedQuery.class, params);
    }

    public List<SavedQuery> getSavedQueries() throws RedmineException {
        return this.transport.getObjectsList(SavedQuery.class, new NameValuePair[0]);
    }

    public IssueRelation createRelation(Integer issueId, Integer issueToId, String type) throws RedmineException {
        IssueRelation toCreate = new IssueRelation();
        toCreate.setIssueId(issueId);
        toCreate.setIssueToId(issueToId);
        toCreate.setType(type);
        return this.transport.addChildEntry(Issue.class, issueId.toString(), toCreate, new NameValuePair[0]);
    }

    public void deleteRelation(Integer id) throws RedmineException {
        this.transport.deleteObject(IssueRelation.class, Integer.toString(id));
    }

    public void deleteIssueRelations(Issue redmineIssue) throws RedmineException {
        for (IssueRelation relation : redmineIssue.getRelations()) {
            this.deleteRelation(relation.getId());
        }
    }

    public void deleteIssueRelationsByIssueId(Integer id) throws RedmineException {
        Issue issue = this.getIssueById(id, INCLUDE.relations);
        this.deleteIssueRelations(issue);
    }

    public List<IssueStatus> getStatuses() throws RedmineException {
        return this.transport.getObjectsList(IssueStatus.class, new NameValuePair[0]);
    }

    public Version createVersion(Version version) throws RedmineException {
        if (version.getProject() == null || version.getProject().getId() == null) {
            throw new IllegalArgumentException("Version must contain an existing project");
        }
        return this.transport.addChildEntry(Project.class, version.getProject().getId().toString(), version, new NameValuePair[0]);
    }

    public void deleteVersion(Version version) throws RedmineException {
        this.transport.deleteObject(Version.class, Integer.toString(version.getId()));
    }

    public List<Version> getVersions(int projectID) throws RedmineException {
        return this.transport.getChildEntries(Project.class, Integer.toString(projectID), Version.class);
    }

    public Version getVersionById(int versionId) throws RedmineException {
        return this.transport.getObject(Version.class, versionId, new NameValuePair[0]);
    }

    public List<IssueCategory> getCategories(int projectID) throws RedmineException {
        return this.transport.getChildEntries(Project.class, Integer.toString(projectID), IssueCategory.class);
    }

    public IssueCategory createCategory(IssueCategory category) throws RedmineException {
        if (category.getProject() == null || category.getProject().getId() == null) {
            throw new IllegalArgumentException("IssueCategory must contain an existing project");
        }
        return this.transport.addChildEntry(Project.class, category.getProject().getId().toString(), category, new NameValuePair[0]);
    }

    public void deleteCategory(IssueCategory category) throws RedmineException {
        this.transport.deleteObject(IssueCategory.class, Integer.toString(category.getId()));
    }

    public List<Tracker> getTrackers() throws RedmineException {
        return this.transport.getObjectsList(Tracker.class, new NameValuePair[0]);
    }

    public Attachment getAttachmentById(int attachmentID) throws RedmineException {
        return this.transport.getObject(Attachment.class, attachmentID, new NameValuePair[0]);
    }

    public void downloadAttachmentContent(Attachment issueAttachment, OutputStream stream) throws RedmineException {
        this.transport.download(issueAttachment.getContentURL(), new CopyBytesHandler(stream));
    }

    public byte[] downloadAttachmentContent(Attachment issueAttachment) throws RedmineException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.downloadAttachmentContent(issueAttachment, baos);
        try {
            baos.close();
        }
        catch (IOException e) {
            throw new RedmineInternalError();
        }
        return baos.toByteArray();
    }

    public void setLogin(String login) {
        this.transport.setLogin(login);
    }

    public void setPassword(String password) {
        this.transport.setPassword(password);
    }

    public List<News> getNews(String projectKey) throws RedmineException {
        HashSet<BasicNameValuePair> params = new HashSet<BasicNameValuePair>();
        if (projectKey != null && projectKey.length() > 0) {
            params.add(new BasicNameValuePair("project_id", projectKey));
        }
        return this.transport.getObjectsList(News.class, params);
    }

    public void shutdown() {
        this.transport.shutdown();
    }

    private void unwrapException(RedmineException exception, String tag) throws IOException {
        for (Throwable e = exception; e != null; e = e.getCause()) {
            MarkedIOException marked;
            if (!(e instanceof MarkedIOException) || !tag.equals((marked = (MarkedIOException)e).getTag())) continue;
            throw marked.getIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attachment uploadAttachment(String fileName, String contentType, byte[] content) throws RedmineException, IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        try {
            Attachment attachment = this.uploadAttachment(fileName, contentType, is);
            return attachment;
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                throw new RedmineInternalError("Unexpected exception", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attachment uploadAttachment(String contentType, File content) throws RedmineException, IOException {
        FileInputStream is = new FileInputStream(content);
        try {
            Attachment attachment = this.uploadAttachment(content.getName(), contentType, is);
            return attachment;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public Attachment uploadAttachment(String fileName, String contentType, InputStream content) throws RedmineException, IOException {
        MarkedInputStream wrapper = new MarkedInputStream(content, "uploadStream");
        try {
            String token = this.transport.upload(wrapper);
            Attachment result = new Attachment();
            result.setToken(token);
            result.setContentType(contentType);
            result.setFileName(fileName);
            return result;
        }
        catch (RedmineException e) {
            this.unwrapException(e, "uploadStream");
            throw e;
        }
    }

    public List<Role> getRoles() throws RedmineException {
        return this.transport.getObjectsList(Role.class, new NameValuePair[0]);
    }

    public Role getRoleById(int id) throws RedmineException {
        return this.transport.getObject(Role.class, id, new NameValuePair[0]);
    }

    public List<IssuePriority> getIssuePriorities() throws RedmineException {
        return this.transport.getObjectsList(IssuePriority.class, new NameValuePair[0]);
    }

    public List<TimeEntryActivity> getTimeEntryActivities() throws RedmineException {
        return this.transport.getObjectsList(TimeEntryActivity.class, new NameValuePair[0]);
    }

    public List<Membership> getMemberships(String project) throws RedmineException {
        return this.transport.getChildEntries(Project.class, project, Membership.class);
    }

    public List<Membership> getMemberships(Project project) throws RedmineException {
        return this.getMemberships(this.getProjectKey(project));
    }

    public void addMembership(Membership membership) throws RedmineException {
        Project project = membership.getProject();
        if (project == null) {
            throw new IllegalArgumentException("Project must be set");
        }
        if (membership.getUser() == null) {
            throw new IllegalArgumentException("User must be set");
        }
        this.transport.addChildEntry(Project.class, this.getProjectKey(project), membership, new NameValuePair[0]);
    }

    public Membership getMembership(int id) throws RedmineException {
        return this.transport.getObject(Membership.class, id, new NameValuePair[0]);
    }

    public void deleteMembership(int id) throws RedmineException {
        this.transport.deleteObject(Membership.class, Integer.toString(id));
    }

    public void delete(Membership membership) throws RedmineException {
        this.transport.deleteObject(Membership.class, membership.getId().toString());
    }

    public void addUserToGroup(User user, Group group) throws RedmineException {
        this.transport.addUserToGroup(user.getId(), group.getId());
    }

    private String getProjectKey(Project project) {
        return project.getId() != null ? project.getId().toString() : project.getIdentifier();
    }

    public void addWatcherToIssue(Watcher watcher, Issue issue) throws RedmineException {
        this.transport.addWatcherToIssue(watcher.getId(), issue.getId());
    }

    public void deleteWatcherFromIssue(Watcher watcher, Issue issue) throws RedmineException {
        this.transport.deleteChildId(Issue.class, Integer.toString(issue.getId()), watcher, watcher.getId());
    }

    public static enum INCLUDE {
        journals,
        relations,
        attachments,
        changesets,
        watchers;

    }
}

