/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.internal.comm;

import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionManager;

final class ConnectionEvictor
implements Runnable {
    private boolean terminate;
    private final ClientConnectionManager connManager;
    private final long evictionInverval;
    private final int idleTimeout;

    public ConnectionEvictor(ClientConnectionManager connManager, int evictionInverval, int idleTimeout) {
        this.connManager = connManager;
        this.evictionInverval = (long)evictionInverval * 1000L;
        this.idleTimeout = idleTimeout;
    }

    @Override
    public void run() {
        while (this.getNextEviction()) {
            this.connManager.closeExpiredConnections();
            this.connManager.closeIdleConnections((long)this.idleTimeout, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getNextEviction() {
        long nowTime = System.currentTimeMillis();
        long sleepEndTime = nowTime + this.evictionInverval;
        while (nowTime < sleepEndTime) {
            long toSleep = Math.max(100L, sleepEndTime - nowTime);
            ConnectionEvictor connectionEvictor = this;
            synchronized (connectionEvictor) {
                if (this.terminate) {
                    return false;
                }
                try {
                    this.wait(toSleep);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            nowTime = System.currentTimeMillis();
        }
        return true;
    }

    synchronized void shutdown() {
        this.terminate = true;
        this.notifyAll();
    }
}

