/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.internal.comm;

import com.taskadapter.redmineapi.RedmineConfigurationException;
import com.taskadapter.redmineapi.internal.comm.naivessl.NaiveSSLFactory;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;

class HttpUtil {
    HttpUtil() {
    }

    public static DefaultHttpClient getNewHttpClient(ClientConnectionManager connectionManager) {
        try {
            BasicHttpParams params = new BasicHttpParams();
            HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
            DefaultHttpClient result = new DefaultHttpClient(connectionManager, (HttpParams)params);
            HttpUtil.configureProxy(result);
            return result;
        }
        catch (Exception e) {
            return new DefaultHttpClient();
        }
    }

    static PoolingClientConnectionManager createConnectionManager(int maxConnections) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, KeyManagementException, UnrecoverableKeyException {
        SSLSocketFactory factory = NaiveSSLFactory.createNaiveSSLSocketFactory();
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        registry.register(new Scheme("https", 443, (SchemeSocketFactory)factory));
        PoolingClientConnectionManager manager = new PoolingClientConnectionManager(registry);
        manager.setMaxTotal(maxConnections);
        manager.setDefaultMaxPerRoute(maxConnections);
        return manager;
    }

    private static void configureProxy(DefaultHttpClient httpclient) {
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (proxyHost != null && proxyPort != null) {
            int port;
            try {
                port = Integer.parseInt(proxyPort);
            }
            catch (NumberFormatException e) {
                throw new RedmineConfigurationException("Illegal proxy port " + proxyPort, e);
            }
            HttpHost proxy = new HttpHost(proxyHost, port);
            httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            String proxyUser = System.getProperty("http.proxyUser");
            if (proxyUser != null) {
                String proxyPassword = System.getProperty("http.proxyPassword");
                httpclient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, port), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
            }
        }
    }

    public static String getEntityEncoding(HttpEntity entity) {
        Header header = entity.getContentEncoding();
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    public static String getCharset(HttpEntity entity) {
        String guess = EntityUtils.getContentCharSet((HttpEntity)entity);
        return guess == null ? "ISO-8859-1" : guess;
    }
}

