/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.bean.Group;
import com.taskadapter.redmineapi.bean.Role;
import com.taskadapter.redmineapi.bean.User;
import com.taskadapter.redmineapi.internal.Transport;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class UserManager {
    private final Transport transport;

    UserManager(Transport transport) {
        this.transport = transport;
    }

    public User getCurrentUser() throws RedmineException {
        return this.transport.getCurrentUser(new NameValuePair[0]);
    }

    public User createUser(User user) throws RedmineException {
        return this.transport.addObject(user, new NameValuePair[0]);
    }

    public void deleteUser(Integer userId) throws RedmineException {
        this.transport.deleteObject(User.class, Integer.toString(userId));
    }

    public void addUserToGroup(User user, Group group) throws RedmineException {
        this.transport.addUserToGroup(user.getId(), group.getId());
    }

    public List<User> getUsers() throws RedmineException {
        return this.transport.getObjectsList(User.class, new NameValuePair[]{new BasicNameValuePair("include", "memberships,groups")});
    }

    public User getUserById(Integer userId) throws RedmineException {
        return this.transport.getObject(User.class, userId, new NameValuePair[]{new BasicNameValuePair("include", "memberships,groups")});
    }

    public List<Group> getGroups() throws RedmineException {
        return this.transport.getObjectsList(Group.class, new NameValuePair[0]);
    }

    public Group getGroupById(int id) throws RedmineException {
        return this.transport.getObject(Group.class, id, new NameValuePair[0]);
    }

    public Group getGroupByName(String name) throws RedmineException {
        return this.transport.getObject(Group.class, name, new NameValuePair[0]);
    }

    public Group createGroup(Group base) throws RedmineException {
        return this.transport.addObject(base, new NameValuePair[0]);
    }

    public void deleteGroup(Group base) throws RedmineException {
        this.transport.deleteObject(Group.class, base.getId().toString());
    }

    public List<Role> getRoles() throws RedmineException {
        return this.transport.getObjectsList(Role.class, new NameValuePair[0]);
    }

    public Role getRoleById(int id) throws RedmineException {
        return this.transport.getObject(Role.class, id, new NameValuePair[0]);
    }

    public void update(User obj) throws RedmineException {
        this.transport.updateObject(obj, new NameValuePair[0]);
    }

    public void update(Group group) throws RedmineException {
        this.transport.updateObject(group, new NameValuePair[0]);
    }
}

