/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.bean;

import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.Identifiable;
import com.taskadapter.redmineapi.bean.Project;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;

public class Version
implements Identifiable {
    public static final String STATUS_OPEN = "open";
    public static final String STATUS_LOCKED = "locked";
    public static final String STATUS_CLOSED = "closed";
    public static final String SHARING_NONE = "none";
    public static final String SHARING_DESCENDANTS = "descendants";
    public static final String SHARING_HIERARCHY = "hierarchy";
    public static final String SHARING_TREE = "tree";
    public static final String SHARING_SYSTEM = "system";
    private final Integer id;
    private Project project;
    private String name;
    private String description;
    private String status;
    private Date dueDate;
    private String sharing;
    private Date createdOn;
    private Date updatedOn;
    private final Collection<CustomField> customFields = new HashSet<CustomField>();

    Version(Integer id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return !(this.id != null ? !this.id.equals(version.id) : version.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Project getProject() {
        return this.project;
    }

    public String getSharing() {
        return this.sharing;
    }

    public String getStatus() {
        return this.status;
    }

    public Date getUpdatedOn() {
        return this.updatedOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setSharing(String sharing) {
        this.sharing = sharing;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setUpdatedOn(Date updatedOn) {
        this.updatedOn = updatedOn;
    }

    public Collection<CustomField> getCustomFields() {
        return Collections.unmodifiableCollection(this.customFields);
    }

    public void addCustomFields(Collection<CustomField> customFields) {
        this.customFields.addAll(customFields);
    }

    public CustomField getCustomFieldById(int customFieldId) {
        for (CustomField customField : this.customFields) {
            if (customFieldId != customField.getId()) continue;
            return customField;
        }
        return null;
    }

    public String toString() {
        return "Version [id=" + this.id + ", name=" + this.name + "]";
    }
}

