/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.internal;

import com.taskadapter.redmineapi.bean.Attachment;
import com.taskadapter.redmineapi.bean.AttachmentFactory;
import com.taskadapter.redmineapi.bean.Changeset;
import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.CustomFieldDefinition;
import com.taskadapter.redmineapi.bean.CustomFieldDefinitionFactory;
import com.taskadapter.redmineapi.bean.CustomFieldFactory;
import com.taskadapter.redmineapi.bean.Group;
import com.taskadapter.redmineapi.bean.GroupFactory;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.IssueCategoryFactory;
import com.taskadapter.redmineapi.bean.IssueFactory;
import com.taskadapter.redmineapi.bean.IssuePriority;
import com.taskadapter.redmineapi.bean.IssuePriorityFactory;
import com.taskadapter.redmineapi.bean.IssueRelation;
import com.taskadapter.redmineapi.bean.IssueRelationFactory;
import com.taskadapter.redmineapi.bean.IssueStatus;
import com.taskadapter.redmineapi.bean.IssueStatusFactory;
import com.taskadapter.redmineapi.bean.Journal;
import com.taskadapter.redmineapi.bean.JournalDetail;
import com.taskadapter.redmineapi.bean.JournalFactory;
import com.taskadapter.redmineapi.bean.Membership;
import com.taskadapter.redmineapi.bean.MembershipFactory;
import com.taskadapter.redmineapi.bean.News;
import com.taskadapter.redmineapi.bean.NewsFactory;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.ProjectFactory;
import com.taskadapter.redmineapi.bean.Role;
import com.taskadapter.redmineapi.bean.RoleFactory;
import com.taskadapter.redmineapi.bean.SavedQuery;
import com.taskadapter.redmineapi.bean.SavedQueryFactory;
import com.taskadapter.redmineapi.bean.TimeEntry;
import com.taskadapter.redmineapi.bean.TimeEntryActivity;
import com.taskadapter.redmineapi.bean.TimeEntryActivityFactory;
import com.taskadapter.redmineapi.bean.TimeEntryFactory;
import com.taskadapter.redmineapi.bean.Tracker;
import com.taskadapter.redmineapi.bean.TrackerFactory;
import com.taskadapter.redmineapi.bean.User;
import com.taskadapter.redmineapi.bean.UserFactory;
import com.taskadapter.redmineapi.bean.Version;
import com.taskadapter.redmineapi.bean.VersionFactory;
import com.taskadapter.redmineapi.bean.Watcher;
import com.taskadapter.redmineapi.bean.WatcherFactory;
import com.taskadapter.redmineapi.bean.WikiPage;
import com.taskadapter.redmineapi.bean.WikiPageDetail;
import com.taskadapter.redmineapi.bean.WikiPageFactory;
import com.taskadapter.redmineapi.internal.RedmineDateParser;
import com.taskadapter.redmineapi.internal.json.JsonInput;
import com.taskadapter.redmineapi.internal.json.JsonObjectParser;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RedmineJSONParser {
    public static final JsonObjectParser<Tracker> TRACKER_PARSER = new JsonObjectParser<Tracker>(){

        @Override
        public Tracker parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseTracker(input);
        }
    };
    public static final JsonObjectParser<IssueStatus> STATUS_PARSER = new JsonObjectParser<IssueStatus>(){

        @Override
        public IssueStatus parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseStatus(input);
        }
    };
    public static final JsonObjectParser<Project> MINIMAL_PROJECT_PARSER = new JsonObjectParser<Project>(){

        @Override
        public Project parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseMinimalProject(input);
        }
    };
    public static final JsonObjectParser<Project> PROJECT_PARSER = new JsonObjectParser<Project>(){

        @Override
        public Project parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseProject(input);
        }
    };
    public static final JsonObjectParser<Issue> ISSUE_PARSER = new JsonObjectParser<Issue>(){

        @Override
        public Issue parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseIssue(input);
        }
    };
    public static final JsonObjectParser<User> USER_PARSER = new JsonObjectParser<User>(){

        @Override
        public User parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseUser(input);
        }
    };
    public static final JsonObjectParser<Group> GROUP_PARSER = new JsonObjectParser<Group>(){

        @Override
        public Group parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseGroup(input);
        }
    };
    public static final JsonObjectParser<CustomField> CUSTOM_FIELD_PARSER = new JsonObjectParser<CustomField>(){

        @Override
        public CustomField parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseCustomField(input);
        }
    };
    public static final JsonObjectParser<Journal> JOURNAL_PARSER = new JsonObjectParser<Journal>(){

        @Override
        public Journal parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseJournal(input);
        }
    };
    public static final JsonObjectParser<JournalDetail> JOURNAL_DETAIL_PARSER = new JsonObjectParser<JournalDetail>(){

        @Override
        public JournalDetail parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseJournalDetail(input);
        }
    };
    public static final JsonObjectParser<Attachment> ATTACHMENT_PARSER = new JsonObjectParser<Attachment>(){

        @Override
        public Attachment parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseAttachments(input);
        }
    };
    public static final JsonObjectParser<IssueRelation> RELATION_PARSER = new JsonObjectParser<IssueRelation>(){

        @Override
        public IssueRelation parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseRelation(input);
        }
    };
    public static final JsonObjectParser<News> NEWS_PARSER = new JsonObjectParser<News>(){

        @Override
        public News parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseNews(input);
        }
    };
    public static final JsonObjectParser<Version> VERSION_PARSER = new JsonObjectParser<Version>(){

        @Override
        public Version parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseVersion(input);
        }
    };
    public static final JsonObjectParser<IssueCategory> CATEGORY_PARSER = new JsonObjectParser<IssueCategory>(){

        @Override
        public IssueCategory parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseCategory(input);
        }
    };
    public static final JsonObjectParser<TimeEntry> TIME_ENTRY_PARSER = new JsonObjectParser<TimeEntry>(){

        @Override
        public TimeEntry parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseTimeEntry(input);
        }
    };
    public static final JsonObjectParser<SavedQuery> QUERY_PARSER = new JsonObjectParser<SavedQuery>(){

        @Override
        public SavedQuery parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseSavedQuery(input);
        }
    };
    public static final JsonObjectParser<String> UPLOAD_TOKEN_PARSER = new JsonObjectParser<String>(){

        @Override
        public String parse(JSONObject input) throws JSONException {
            return JsonInput.getStringNotNull(input, "token");
        }
    };
    public static final JsonObjectParser<Role> ROLE_PARSER = new JsonObjectParser<Role>(){

        @Override
        public Role parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseRole(input);
        }
    };
    public static final JsonObjectParser<Membership> MEMBERSHIP_PARSER = new JsonObjectParser<Membership>(){

        @Override
        public Membership parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseMembership(input);
        }
    };
    public static final JsonObjectParser<Changeset> CHANGESET_PARSER = new JsonObjectParser<Changeset>(){

        @Override
        public Changeset parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseChangeset(input);
        }
    };
    public static final JsonObjectParser<Watcher> WATCHER_PARSER = new JsonObjectParser<Watcher>(){

        @Override
        public Watcher parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseWatcher(input);
        }
    };
    public static final JsonObjectParser<IssuePriority> ISSUE_PRIORITY_PARSER = new JsonObjectParser<IssuePriority>(){

        @Override
        public IssuePriority parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseIssuePriority(input);
        }
    };
    public static final JsonObjectParser<TimeEntryActivity> TIME_ENTRY_ACTIVITY_PARSER = new JsonObjectParser<TimeEntryActivity>(){

        @Override
        public TimeEntryActivity parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseTimeEntryActivity(input);
        }
    };
    public static final JsonObjectParser<WikiPage> WIKI_PAGE_PARSER = new JsonObjectParser<WikiPage>(){

        @Override
        public WikiPage parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseWikiPage(input);
        }
    };
    public static final JsonObjectParser<WikiPageDetail> WIKI_PAGE_DETAIL_PARSER = new JsonObjectParser<WikiPageDetail>(){

        @Override
        public WikiPageDetail parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseWikiPageDetail(input);
        }
    };
    public static final JsonObjectParser<CustomFieldDefinition> CUSTOM_FIELD_DEFINITION_PARSER = new JsonObjectParser<CustomFieldDefinition>(){

        @Override
        public CustomFieldDefinition parse(JSONObject input) throws JSONException {
            return RedmineJSONParser.parseCustomFieldDefinition(input);
        }
    };

    public static Tracker parseTracker(JSONObject object) throws JSONException {
        int id = JsonInput.getInt(object, "id");
        String name = JsonInput.getStringNotNull(object, "name");
        return TrackerFactory.create(id, name);
    }

    public static IssueStatus parseStatus(JSONObject object) throws JSONException {
        int id = JsonInput.getInt(object, "id");
        String name = JsonInput.getStringNotNull(object, "name");
        IssueStatus result = IssueStatusFactory.create(id, name);
        if (object.has("is_default")) {
            result.setDefaultStatus(JsonInput.getOptionalBool(object, "is_default"));
        }
        if (object.has("is_closed")) {
            result.setClosed(JsonInput.getOptionalBool(object, "is_closed"));
        }
        return result;
    }

    public static SavedQuery parseSavedQuery(JSONObject object) throws JSONException {
        SavedQuery result = SavedQueryFactory.create(JsonInput.getIntOrNull(object, "id"));
        result.setName(JsonInput.getStringOrNull(object, "name"));
        result.setPublicQuery(JsonInput.getOptionalBool(object, "is_public"));
        result.setProjectId(JsonInput.getIntOrNull(object, "project_id"));
        return result;
    }

    public static News parseNews(JSONObject object) throws JSONException {
        News result = NewsFactory.create(JsonInput.getIntOrNull(object, "id"));
        result.setProject(JsonInput.getObjectOrNull(object, "project", MINIMAL_PROJECT_PARSER));
        result.setUser(JsonInput.getObjectOrNull(object, "author", USER_PARSER));
        result.setTitle(JsonInput.getStringOrNull(object, "title"));
        result.setDescription(JsonInput.getStringOrNull(object, "description"));
        result.setCreatedOn(RedmineJSONParser.getDateOrNull(object, "created_on"));
        result.setLink(JsonInput.getStringOrNull(object, "link"));
        return result;
    }

    public static TimeEntry parseTimeEntry(JSONObject object) throws JSONException {
        JSONObject activity;
        JSONObject user;
        JSONObject projectObject;
        TimeEntry result = TimeEntryFactory.create(JsonInput.getIntOrNull(object, "id"));
        JSONObject issueObject = JsonInput.getObjectOrNull(object, "issue");
        if (issueObject != null) {
            result.setIssueId(JsonInput.getIntOrNull(issueObject, "id"));
        }
        if ((projectObject = JsonInput.getObjectOrNull(object, "project")) != null) {
            result.setProjectId(JsonInput.getIntOrNull(projectObject, "id"));
            result.setProjectName(JsonInput.getStringOrNull(projectObject, "name"));
        }
        if ((user = JsonInput.getObjectOrNull(object, "user")) != null) {
            result.setUserId(JsonInput.getIntOrNull(user, "id"));
            result.setUserName(JsonInput.getStringOrNull(user, "name"));
        }
        if ((activity = JsonInput.getObjectOrNull(object, "activity")) != null) {
            result.setActivityId(JsonInput.getIntOrNull(activity, "id"));
            result.setActivityName(JsonInput.getStringOrNull(activity, "name"));
        }
        result.setHours(JsonInput.getFloatOrNull(object, "hours"));
        result.setComment(JsonInput.getStringOrEmpty(object, "comments"));
        result.setSpentOn(RedmineJSONParser.getDateOrNull(object, "spent_on"));
        result.setCreatedOn(RedmineJSONParser.getDateOrNull(object, "created_on"));
        result.setUpdatedOn(RedmineJSONParser.getDateOrNull(object, "updated_on"));
        return result;
    }

    public static Project parseMinimalProject(JSONObject content) throws JSONException {
        Project result = ProjectFactory.create(JsonInput.getInt(content, "id"));
        result.setIdentifier(JsonInput.getStringOrNull(content, "identifier"));
        result.setName(JsonInput.getStringNotNull(content, "name"));
        return result;
    }

    public static Project parseProject(JSONObject content) throws JSONException {
        Project result = ProjectFactory.create(JsonInput.getInt(content, "id"));
        result.setIdentifier(JsonInput.getStringOrNull(content, "identifier"));
        result.setName(JsonInput.getStringNotNull(content, "name"));
        result.setDescription(JsonInput.getStringOrEmpty(content, "description"));
        result.setHomepage(JsonInput.getStringOrEmpty(content, "homepage"));
        result.setCreatedOn(RedmineJSONParser.getDateOrNull(content, "created_on"));
        result.setUpdatedOn(RedmineJSONParser.getDateOrNull(content, "updated_on"));
        JSONObject parentProject = JsonInput.getObjectOrNull(content, "parent");
        if (parentProject != null) {
            result.setParentId(JsonInput.getInt(parentProject, "id"));
        }
        result.addTrackers(JsonInput.getListOrEmpty(content, "trackers", TRACKER_PARSER));
        result.addCustomFields(JsonInput.getListOrEmpty(content, "custom_fields", CUSTOM_FIELD_PARSER));
        return result;
    }

    public static Issue parseIssue(JSONObject content) throws JSONException {
        Issue result = IssueFactory.create(JsonInput.getIntOrNull(content, "id"));
        result.setSubject(JsonInput.getStringOrNull(content, "subject"));
        JSONObject parentIssueObject = JsonInput.getObjectOrNull(content, "parent");
        if (parentIssueObject != null) {
            result.setParentId(JsonInput.getInt(parentIssueObject, "id"));
        }
        result.setEstimatedHours(JsonInput.getFloatOrNull(content, "estimated_hours"));
        result.setSpentHours(JsonInput.getFloatOrNull(content, "spent_hours"));
        result.setAssignee(JsonInput.getObjectOrNull(content, "assigned_to", USER_PARSER));
        JSONObject priorityObject = JsonInput.getObjectOrNull(content, "priority");
        if (priorityObject != null) {
            result.setPriorityText(JsonInput.getStringOrNull(priorityObject, "name"));
            result.setPriorityId(JsonInput.getIntOrNull(priorityObject, "id"));
        }
        result.setDoneRatio(JsonInput.getIntOrNull(content, "done_ratio"));
        result.setProject(JsonInput.getObjectOrNull(content, "project", MINIMAL_PROJECT_PARSER));
        result.setAuthor(JsonInput.getObjectOrNull(content, "author", USER_PARSER));
        result.setStartDate(RedmineJSONParser.getDateOrNull(content, "start_date"));
        result.setDueDate(RedmineJSONParser.getDateOrNull(content, "due_date"));
        result.setTracker(JsonInput.getObjectOrNull(content, "tracker", TRACKER_PARSER));
        result.setDescription(JsonInput.getStringOrEmpty(content, "description"));
        result.setCreatedOn(RedmineJSONParser.getDateOrNull(content, "created_on"));
        result.setUpdatedOn(RedmineJSONParser.getDateOrNull(content, "updated_on"));
        JSONObject statusObject = JsonInput.getObjectOrNull(content, "status");
        if (statusObject != null) {
            result.setStatusName(JsonInput.getStringOrNull(statusObject, "name"));
            result.setStatusId(JsonInput.getIntOrNull(statusObject, "id"));
        }
        result.addCustomFields(JsonInput.getListOrEmpty(content, "custom_fields", CUSTOM_FIELD_PARSER));
        result.setNotes(JsonInput.getStringOrNull(content, "notes"));
        result.addJournals(JsonInput.getListOrEmpty(content, "journals", JOURNAL_PARSER));
        result.addAttachments(JsonInput.getListOrEmpty(content, "attachments", ATTACHMENT_PARSER));
        result.addRelations(JsonInput.getListOrEmpty(content, "relations", RELATION_PARSER));
        result.setTargetVersion(JsonInput.getObjectOrNull(content, "fixed_version", VERSION_PARSER));
        result.setCategory(JsonInput.getObjectOrNull(content, "category", CATEGORY_PARSER));
        result.addChangesets(JsonInput.getListOrEmpty(content, "changesets", CHANGESET_PARSER));
        result.addWatchers(JsonInput.getListOrEmpty(content, "watchers", WATCHER_PARSER));
        return result;
    }

    public static IssueCategory parseCategory(JSONObject content) throws JSONException {
        IssueCategory result = IssueCategoryFactory.create(JsonInput.getInt(content, "id"));
        result.setName(JsonInput.getStringOrNull(content, "name"));
        result.setProject(JsonInput.getObjectOrNull(content, "project", MINIMAL_PROJECT_PARSER));
        result.setAssignee(JsonInput.getObjectOrNull(content, "assigned_to", USER_PARSER));
        return result;
    }

    public static Version parseVersion(JSONObject content) throws JSONException {
        Version result = VersionFactory.create(JsonInput.getIntOrNull(content, "id"));
        result.setProject(JsonInput.getObjectOrNull(content, "project", MINIMAL_PROJECT_PARSER));
        result.setName(JsonInput.getStringOrNull(content, "name"));
        result.setDescription(JsonInput.getStringOrNull(content, "description"));
        result.setSharing(JsonInput.getStringOrNull(content, "sharing"));
        result.setStatus(JsonInput.getStringOrNull(content, "status"));
        result.setDueDate(RedmineJSONParser.getDateOrNull(content, "due_date"));
        result.setCreatedOn(RedmineJSONParser.getDateOrNull(content, "created_on"));
        result.setUpdatedOn(RedmineJSONParser.getDateOrNull(content, "updated_on"));
        result.addCustomFields(JsonInput.getListOrEmpty(content, "custom_fields", CUSTOM_FIELD_PARSER));
        return result;
    }

    public static IssueRelation parseRelation(JSONObject content) throws JSONException {
        IssueRelation result = IssueRelationFactory.create(JsonInput.getIntOrNull(content, "id"));
        result.setIssueId(JsonInput.getIntOrNull(content, "issue_id"));
        result.setIssueToId(JsonInput.getIntOrNull(content, "issue_to_id"));
        result.setType(JsonInput.getStringOrNull(content, "relation_type"));
        result.setDelay(JsonInput.getInt(content, "delay", 0));
        return result;
    }

    public static Attachment parseAttachments(JSONObject content) throws JSONException {
        Attachment result = AttachmentFactory.create(JsonInput.getIntOrNull(content, "id"));
        result.setFileName(JsonInput.getStringOrNull(content, "filename"));
        result.setFileSize(JsonInput.getLong(content, "filesize"));
        result.setContentType(JsonInput.getStringOrNull(content, "content_type"));
        result.setContentURL(JsonInput.getStringOrNull(content, "content_url"));
        result.setDescription(JsonInput.getStringOrNull(content, "description"));
        result.setCreatedOn(RedmineJSONParser.getDateOrNull(content, "created_on"));
        result.setAuthor(JsonInput.getObjectOrNull(content, "author", USER_PARSER));
        return result;
    }

    public static CustomField parseCustomField(JSONObject content) throws JSONException {
        CustomField result = CustomFieldFactory.create(JsonInput.getInt(content, "id"));
        result.setName(JsonInput.getStringOrNull(content, "name"));
        if (!content.has("multiple")) {
            result.setValue(JsonInput.getStringOrNull(content, "value"));
        } else {
            ArrayList<String> strings = new ArrayList<String>();
            Object value = content.get("value");
            if (value instanceof JSONArray) {
                JSONArray tmp = (JSONArray)value;
                for (int i = 0; i < tmp.length(); ++i) {
                    strings.add(String.valueOf(tmp.get(i)));
                }
            }
            result.setValues(strings);
        }
        return result;
    }

    public static Journal parseJournal(JSONObject content) throws JSONException {
        Journal result = JournalFactory.create(JsonInput.getInt(content, "id"));
        result.setCreatedOn(RedmineJSONParser.getDateOrNull(content, "created_on"));
        result.setNotes(JsonInput.getStringOrNull(content, "notes"));
        result.setUser(JsonInput.getObjectOrNull(content, "user", USER_PARSER));
        result.addDetails(JsonInput.getListOrEmpty(content, "details", JOURNAL_DETAIL_PARSER));
        return result;
    }

    public static JournalDetail parseJournalDetail(JSONObject content) throws JSONException {
        JournalDetail result = new JournalDetail();
        result.setNewValue(JsonInput.getStringOrNull(content, "new_value"));
        result.setOldValue(JsonInput.getStringOrNull(content, "old_value"));
        result.setName(JsonInput.getStringOrNull(content, "name"));
        result.setProperty(JsonInput.getStringOrNull(content, "property"));
        return result;
    }

    public static Changeset parseChangeset(JSONObject content) throws JSONException {
        Changeset result = new Changeset();
        result.setRevision(JsonInput.getStringOrNull(content, "revision"));
        result.setUser(JsonInput.getObjectOrNull(content, "user", USER_PARSER));
        result.setComments(JsonInput.getStringOrNull(content, "comments"));
        result.setCommittedOn(RedmineJSONParser.getDateOrNull(content, "committed_on"));
        return result;
    }

    public static User parseUser(JSONObject content) throws JSONException {
        User result = UserFactory.create(JsonInput.getIntOrNull(content, "id"));
        result.setLogin(JsonInput.getStringOrNull(content, "login"));
        result.setPassword(JsonInput.getStringOrNull(content, "password"));
        result.setFirstName(JsonInput.getStringOrNull(content, "firstname"));
        result.setLastName(JsonInput.getStringOrNull(content, "lastname"));
        result.setMail(JsonInput.getStringOrNull(content, "mail"));
        result.setAuthSourceId(JsonInput.getIntOrNull(content, "auth_source_id"));
        result.setCreatedOn(RedmineJSONParser.getDateOrNull(content, "created_on"));
        result.setLastLoginOn(RedmineJSONParser.getDateOrNull(content, "last_login_on"));
        result.setApiKey(JsonInput.getStringOrNull(content, "api_key"));
        result.addCustomFields(JsonInput.getListOrEmpty(content, "custom_fields", CUSTOM_FIELD_PARSER));
        result.setStatus(JsonInput.getIntOrNull(content, "status"));
        String name = JsonInput.getStringOrNull(content, "name");
        if (name != null) {
            result.setFullName(name);
        }
        result.addMemberships(JsonInput.getListOrEmpty(content, "memberships", MEMBERSHIP_PARSER));
        result.addGroups(JsonInput.getListOrEmpty(content, "groups", GROUP_PARSER));
        for (Membership m : result.getMemberships()) {
            m.setUser(result);
        }
        return result;
    }

    public static Group parseGroup(JSONObject content) throws JSONException {
        Group result = GroupFactory.create(JsonInput.getIntOrNull(content, "id"));
        result.setName(JsonInput.getStringOrNull(content, "name"));
        return result;
    }

    public static Role parseRole(JSONObject content) throws JSONException {
        Role role = RoleFactory.create(JsonInput.getIntOrNull(content, "id"));
        role.setName(JsonInput.getStringOrNull(content, "name"));
        role.setInherited(content.has("inherited") && content.getBoolean("inherited"));
        if (content.has("permissions")) {
            JSONArray perms = content.getJSONArray("permissions");
            HashSet<String> permSet = new HashSet<String>();
            for (int i = 0; i < perms.length(); ++i) {
                permSet.add(perms.getString(i));
            }
            role.addPermissions(permSet);
        }
        return role;
    }

    public static Membership parseMembership(JSONObject content) throws JSONException {
        Membership result = MembershipFactory.create(JsonInput.getIntOrNull(content, "id"));
        result.setProject(JsonInput.getObjectOrNull(content, "project", MINIMAL_PROJECT_PARSER));
        result.setUser(JsonInput.getObjectOrNull(content, "user", USER_PARSER));
        result.setGroup(JsonInput.getObjectOrNull(content, "group", GROUP_PARSER));
        result.addRoles(JsonInput.getListOrEmpty(content, "roles", ROLE_PARSER));
        return result;
    }

    public static IssuePriority parseIssuePriority(JSONObject content) throws JSONException {
        IssuePriority result = IssuePriorityFactory.create(JsonInput.getInt(content, "id"));
        result.setName(JsonInput.getStringNotNull(content, "name"));
        result.setDefault(JsonInput.getOptionalBool(content, "is_default"));
        return result;
    }

    public static TimeEntryActivity parseTimeEntryActivity(JSONObject content) throws JSONException {
        TimeEntryActivity result = TimeEntryActivityFactory.create(JsonInput.getInt(content, "id"));
        result.setName(JsonInput.getStringNotNull(content, "name"));
        result.setDefault(JsonInput.getOptionalBool(content, "is_default"));
        return result;
    }

    public static Watcher parseWatcher(JSONObject content) throws JSONException {
        Watcher result = WatcherFactory.create(JsonInput.getIntOrNull(content, "id"));
        result.setName(JsonInput.getStringOrNull(content, "name"));
        return result;
    }

    public static WikiPage parseWikiPage(JSONObject object) throws JSONException {
        WikiPage wikiPage = WikiPageFactory.create(JsonInput.getStringNotNull(object, "title"));
        wikiPage.setVersion(JsonInput.getIntOrNull(object, "version"));
        wikiPage.setCreatedOn(RedmineJSONParser.getDateOrNull(object, "created_on"));
        wikiPage.setUpdatedOn(RedmineJSONParser.getDateOrNull(object, "updated_on"));
        return wikiPage;
    }

    public static WikiPageDetail parseWikiPageDetail(JSONObject object) throws JSONException {
        WikiPageDetail wikiPage = new WikiPageDetail();
        wikiPage.setTitle(JsonInput.getStringOrEmpty(object, "title"));
        wikiPage.setText(JsonInput.getStringOrEmpty(object, "text"));
        wikiPage.setParent(JsonInput.getObjectOrNull(object, "parent", WIKI_PAGE_DETAIL_PARSER));
        wikiPage.setUser(JsonInput.getObjectOrNull(object, "author", USER_PARSER));
        wikiPage.setVersion(JsonInput.getIntOrNull(object, "version"));
        wikiPage.setCreatedOn(RedmineJSONParser.getDateOrNull(object, "created_on"));
        wikiPage.setUpdatedOn(RedmineJSONParser.getDateOrNull(object, "updated_on"));
        wikiPage.setAttachments(JsonInput.getListOrNull(object, "attachments", ATTACHMENT_PARSER));
        return wikiPage;
    }

    public static List<String> parseErrors(String responseBody) throws JSONException {
        JSONObject body = RedmineJSONParser.getResponse(responseBody);
        JSONArray errorsList = JsonInput.getArrayNotNull(body, "errors");
        ArrayList<String> result = new ArrayList<String>(errorsList.length());
        for (int i = 0; i < errorsList.length(); ++i) {
            result.add(errorsList.get(i).toString());
        }
        return result;
    }

    private static Date getDateOrNull(JSONObject obj, String field) throws JSONException {
        String dateStr = JsonInput.getStringOrNull(obj, field);
        if (dateStr == null) {
            return null;
        }
        try {
            return RedmineDateParser.parse(dateStr);
        }
        catch (ParseException e) {
            throw new JSONException("Cannot parse this date: " + dateStr);
        }
    }

    public static JSONObject getResponseSingleObject(String body, String key) throws JSONException {
        JSONObject bodyJson = new JSONObject(body);
        return JsonInput.getObjectNotNull(bodyJson, key);
    }

    public static JSONObject getResponse(String body) throws JSONException {
        return new JSONObject(body);
    }

    public static CustomFieldDefinition parseCustomFieldDefinition(JSONObject content) throws JSONException {
        String name;
        int id;
        JSONObject valueObject;
        int i;
        JSONArray possible_values;
        CustomFieldDefinition result = CustomFieldDefinitionFactory.create(JsonInput.getInt(content, "id"));
        result.setName(JsonInput.getStringOrNull(content, "name"));
        result.setCustomizedType(JsonInput.getStringNotNull(content, "customized_type"));
        result.setFieldFormat(JsonInput.getStringNotNull(content, "field_format"));
        result.setRegexp(JsonInput.getStringOrEmpty(content, "regexp"));
        result.setMinLength(JsonInput.getIntOrNull(content, "min_length"));
        result.setMaxLength(JsonInput.getIntOrNull(content, "max_length"));
        result.setRequired(content.optBoolean("is_required"));
        result.setFilter(content.optBoolean("is_filter"));
        result.setSearchable(content.optBoolean("searchable"));
        result.setMultiple(content.optBoolean("multiple"));
        result.setDefaultValue(JsonInput.getStringOrEmpty(content, "default_value"));
        result.setVisible(content.optBoolean("visible"));
        if (content.has("possible_values")) {
            possible_values = content.getJSONArray("possible_values");
            for (i = 0; i < possible_values.length(); ++i) {
                valueObject = possible_values.getJSONObject(i);
                result.getPossibleValues().add(valueObject.getString("value"));
            }
        }
        if (content.has("trackers")) {
            possible_values = content.getJSONArray("trackers");
            for (i = 0; i < possible_values.length(); ++i) {
                valueObject = possible_values.getJSONObject(i);
                id = valueObject.getInt("id");
                name = valueObject.getString("name");
                result.getTrackers().add(TrackerFactory.create(id, name));
            }
        }
        if (content.has("roles")) {
            possible_values = content.getJSONArray("roles");
            for (i = 0; i < possible_values.length(); ++i) {
                valueObject = possible_values.getJSONObject(i);
                id = valueObject.getInt("id");
                name = valueObject.getString("name");
                Role role = RoleFactory.create(id);
                role.setName(name);
                result.getRoles().add(role);
            }
        }
        return result;
    }
}

