/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi;

import com.taskadapter.redmineapi.Include;
import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.IssuePriority;
import com.taskadapter.redmineapi.bean.IssueRelation;
import com.taskadapter.redmineapi.bean.IssueRelationFactory;
import com.taskadapter.redmineapi.bean.IssueStatus;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.ProjectFactory;
import com.taskadapter.redmineapi.bean.SavedQuery;
import com.taskadapter.redmineapi.bean.TimeEntry;
import com.taskadapter.redmineapi.bean.TimeEntryActivity;
import com.taskadapter.redmineapi.bean.Tracker;
import com.taskadapter.redmineapi.bean.Watcher;
import com.taskadapter.redmineapi.internal.DirectObjectsSearcher;
import com.taskadapter.redmineapi.internal.Joiner;
import com.taskadapter.redmineapi.internal.Transport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class IssueManager {
    private final Transport transport;

    IssueManager(Transport transport) {
        this.transport = transport;
    }

    public List<Issue> getIssuesBySummary(String projectKey, String summaryField) throws RedmineException {
        if (projectKey != null && projectKey.length() > 0) {
            return this.transport.getObjectsList(Issue.class, new NameValuePair[]{new BasicNameValuePair("subject", summaryField), new BasicNameValuePair("project_id", projectKey)});
        }
        return this.transport.getObjectsList(Issue.class, new NameValuePair[]{new BasicNameValuePair("subject", summaryField)});
    }

    public List<Issue> getIssues(Map<String, String> parameters) throws RedmineException {
        return DirectObjectsSearcher.getObjectsListNoPaging(this.transport, parameters, Issue.class);
    }

    public Issue getIssueById(Integer id, Include ... include) throws RedmineException {
        String value = Joiner.join(",", include);
        return this.transport.getObject(Issue.class, id, new NameValuePair[]{new BasicNameValuePair("include", value)});
    }

    public void addWatcherToIssue(Watcher watcher, Issue issue) throws RedmineException {
        this.transport.addWatcherToIssue(watcher.getId(), issue.getId());
    }

    public void deleteWatcherFromIssue(Watcher watcher, Issue issue) throws RedmineException {
        this.transport.deleteChildId(Issue.class, Integer.toString(issue.getId()), watcher, watcher.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Issue createIssue(String projectKey, Issue issue) throws RedmineException {
        Project oldProject = issue.getProject();
        Project newProject = ProjectFactory.create();
        newProject.setIdentifier(projectKey);
        issue.setProject(newProject);
        try {
            Issue issue2 = this.transport.addObject(issue, new NameValuePair[]{new BasicNameValuePair("include", Include.attachments.toString())});
            return issue2;
        }
        finally {
            issue.setProject(oldProject);
        }
    }

    public Issue createIssue(Issue issue) throws RedmineException {
        return this.transport.addObject(issue, new NameValuePair[]{new BasicNameValuePair("include", Include.attachments.toString())});
    }

    public void deleteIssue(Integer id) throws RedmineException {
        this.transport.deleteObject(Issue.class, Integer.toString(id));
    }

    public List<Issue> getIssues(String projectKey, Integer queryId, Include ... include) throws RedmineException {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        if (queryId != null) {
            params.add(new BasicNameValuePair("query_id", String.valueOf(queryId)));
        }
        if (projectKey != null && projectKey.length() > 0) {
            params.add(new BasicNameValuePair("project_id", projectKey));
        }
        String includeStr = Joiner.join(",", include);
        params.add(new BasicNameValuePair("include", includeStr));
        return this.transport.getObjectsList(Issue.class, params);
    }

    public IssueRelation createRelation(Integer issueId, Integer issueToId, String type) throws RedmineException {
        IssueRelation toCreate = IssueRelationFactory.create();
        toCreate.setIssueId(issueId);
        toCreate.setIssueToId(issueToId);
        toCreate.setType(type);
        return this.transport.addChildEntry(Issue.class, issueId.toString(), toCreate, new NameValuePair[0]);
    }

    public void deleteRelation(Integer id) throws RedmineException {
        this.transport.deleteObject(IssueRelation.class, Integer.toString(id));
    }

    public void deleteIssueRelations(Issue redmineIssue) throws RedmineException {
        for (IssueRelation relation : redmineIssue.getRelations()) {
            this.deleteRelation(relation.getId());
        }
    }

    public void deleteIssueRelationsByIssueId(Integer issueId) throws RedmineException {
        Issue issue = this.getIssueById(issueId, Include.relations);
        this.deleteIssueRelations(issue);
    }

    public List<IssuePriority> getIssuePriorities() throws RedmineException {
        return this.transport.getObjectsList(IssuePriority.class, new NameValuePair[0]);
    }

    public List<TimeEntry> getTimeEntries() throws RedmineException {
        return this.transport.getObjectsList(TimeEntry.class, new NameValuePair[0]);
    }

    public TimeEntry getTimeEntry(Integer id) throws RedmineException {
        return this.transport.getObject(TimeEntry.class, id, new NameValuePair[0]);
    }

    public List<TimeEntry> getTimeEntriesForIssue(Integer issueId) throws RedmineException {
        return this.transport.getObjectsList(TimeEntry.class, new NameValuePair[]{new BasicNameValuePair("issue_id", Integer.toString(issueId))});
    }

    public TimeEntry createTimeEntry(TimeEntry obj) throws RedmineException {
        this.validate(obj);
        return this.transport.addObject(obj, new NameValuePair[0]);
    }

    private void validate(TimeEntry obj) {
        if (!obj.isValid()) {
            throw new IllegalArgumentException("You have to either define a Project or Issue ID for a Time Entry. The given Time Entry object has neither defined.");
        }
    }

    public void deleteTimeEntry(Integer id) throws RedmineException {
        this.transport.deleteObject(TimeEntry.class, Integer.toString(id));
    }

    public List<TimeEntryActivity> getTimeEntryActivities() throws RedmineException {
        return this.transport.getObjectsList(TimeEntryActivity.class, new NameValuePair[0]);
    }

    public void update(TimeEntry obj) throws RedmineException {
        this.validate(obj);
        this.transport.updateObject(obj, new NameValuePair[0]);
    }

    public void update(Issue obj) throws RedmineException {
        this.transport.updateObject(obj, new NameValuePair[0]);
    }

    public List<IssueCategory> getCategories(int projectID) throws RedmineException {
        return this.transport.getChildEntries(Project.class, Integer.toString(projectID), IssueCategory.class);
    }

    public IssueCategory createCategory(IssueCategory category) throws RedmineException {
        if (category.getProject() == null || category.getProject().getId() == null) {
            throw new IllegalArgumentException("IssueCategory must contain an existing project");
        }
        return this.transport.addChildEntry(Project.class, category.getProject().getId().toString(), category, new NameValuePair[0]);
    }

    public void deleteCategory(IssueCategory category) throws RedmineException {
        this.transport.deleteObject(IssueCategory.class, Integer.toString(category.getId()));
    }

    public List<IssueStatus> getStatuses() throws RedmineException {
        return this.transport.getObjectsList(IssueStatus.class, new NameValuePair[0]);
    }

    public List<Tracker> getTrackers() throws RedmineException {
        return this.transport.getObjectsList(Tracker.class, new NameValuePair[0]);
    }

    public List<SavedQuery> getSavedQueries(String projectKey) throws RedmineException {
        HashSet<BasicNameValuePair> params = new HashSet<BasicNameValuePair>();
        if (projectKey != null && projectKey.length() > 0) {
            params.add(new BasicNameValuePair("project_id", projectKey));
        }
        return this.transport.getObjectsList(SavedQuery.class, params);
    }

    public List<SavedQuery> getSavedQueries() throws RedmineException {
        return this.transport.getObjectsList(SavedQuery.class, new NameValuePair[0]);
    }
}

