/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.bean;

import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.Identifiable;
import com.taskadapter.redmineapi.bean.Tracker;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;

public class Project
implements Identifiable,
Serializable {
    private static final long serialVersionUID = 4529305420978716446L;
    private final Integer id;
    private String identifier;
    private String name;
    private String description;
    private String homepage;
    private Date createdOn;
    private Date updatedOn;
    private Integer parentId;
    private Boolean projectPublic;
    private final Collection<CustomField> customFields = new HashSet<CustomField>();
    private final Collection<Tracker> trackers = new HashSet<Tracker>();

    Project(Integer id) {
        this.id = id;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<Tracker> getTrackers() {
        return Collections.unmodifiableCollection(this.trackers);
    }

    public void addTrackers(Collection<Tracker> trackers) {
        this.trackers.addAll(trackers);
    }

    public Tracker getTrackerByName(String trackerName) {
        if (this.trackers == null) {
            return null;
        }
        for (Tracker t : this.trackers) {
            if (!t.getName().equals(trackerName)) continue;
            return t;
        }
        return null;
    }

    public String toString() {
        return "Project{id=" + this.id + ", identifier='" + this.identifier + '\'' + ", name='" + this.name + '\'' + '}';
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getUpdatedOn() {
        return this.updatedOn;
    }

    public void setUpdatedOn(Date updatedOn) {
        this.updatedOn = updatedOn;
    }

    public Integer getParentId() {
        return this.parentId;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    @Deprecated
    public Boolean getProjectPublic() {
        return this.projectPublic;
    }

    public void setProjectPublic(Boolean projectPublic) {
        this.projectPublic = projectPublic;
    }

    public Collection<CustomField> getCustomFields() {
        return this.customFields;
    }

    public void addCustomFields(Collection<CustomField> customFields) {
        this.customFields.addAll(customFields);
    }

    public CustomField getCustomFieldById(int customFieldId) {
        for (CustomField customField : this.customFields) {
            if (customFieldId != customField.getId()) continue;
            return customField;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Project project = (Project)o;
        return !(this.id != null ? !this.id.equals(project.id) : project.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

