/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.bean.Membership;
import com.taskadapter.redmineapi.bean.MembershipFactory;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.ProjectFactory;
import com.taskadapter.redmineapi.bean.Role;
import com.taskadapter.redmineapi.internal.Transport;
import java.util.Collection;
import java.util.List;
import org.apache.http.NameValuePair;

public class MembershipManager {
    private final Transport transport;

    MembershipManager(Transport transport) {
        this.transport = transport;
    }

    public List<Membership> getMemberships(String projectKey) throws RedmineException {
        return this.transport.getChildEntries(Project.class, projectKey, Membership.class);
    }

    public List<Membership> getMemberships(int projectId) throws RedmineException {
        return this.transport.getChildEntries(Project.class, projectId, Membership.class);
    }

    private Membership addMembership(Membership membership) throws RedmineException {
        Project project = membership.getProject();
        if (project == null) {
            throw new IllegalArgumentException("Project must be set");
        }
        if (membership.getUserId() == null && membership.getRoles().isEmpty()) {
            throw new IllegalArgumentException("Either User or Roles field must be set");
        }
        return this.transport.addChildEntry(Project.class, project.getId() + "", membership, new NameValuePair[0]);
    }

    public Membership getMembership(int membershipId) throws RedmineException {
        return this.transport.getObject(Membership.class, membershipId, new NameValuePair[0]);
    }

    public void delete(int membershipId) throws RedmineException {
        this.transport.deleteObject(Membership.class, Integer.toString(membershipId));
    }

    public void delete(Membership membership) throws RedmineException {
        this.transport.deleteObject(Membership.class, membership.getId().toString());
    }

    public void update(Membership membership) throws RedmineException {
        this.transport.updateObject(membership, new NameValuePair[0]);
    }

    public Membership createMembershipForGroup(int projectId, int groupId, Collection<Role> roles) throws RedmineException {
        Membership membership = MembershipFactory.create();
        Project project = ProjectFactory.create(projectId);
        membership.setProject(project);
        membership.setUserId(groupId);
        membership.addRoles(roles);
        return this.addMembership(membership);
    }

    public Membership createMembershipForUser(int projectId, int userId, Collection<Role> roles) throws RedmineException {
        Membership membership = MembershipFactory.create();
        Project project = ProjectFactory.create(projectId);
        membership.setProject(project);
        membership.setUserId(userId);
        membership.addRoles(roles);
        return this.addMembership(membership);
    }
}

