/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.bean.TimeEntry;
import com.taskadapter.redmineapi.bean.TimeEntryActivity;
import com.taskadapter.redmineapi.internal.DirectObjectsSearcher;
import com.taskadapter.redmineapi.internal.ResultsWrapper;
import com.taskadapter.redmineapi.internal.Transport;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public final class TimeEntryManager {
    private final Transport transport;

    TimeEntryManager(Transport transport) {
        this.transport = transport;
    }

    public List<TimeEntry> getTimeEntries() throws RedmineException {
        return this.transport.getObjectsList(TimeEntry.class, new NameValuePair[0]);
    }

    public TimeEntry getTimeEntry(Integer id) throws RedmineException {
        return this.transport.getObject(TimeEntry.class, id, new NameValuePair[0]);
    }

    public List<TimeEntry> getTimeEntriesForIssue(Integer issueId) throws RedmineException {
        return this.transport.getObjectsList(TimeEntry.class, new NameValuePair[]{new BasicNameValuePair("issue_id", Integer.toString(issueId))});
    }

    public ResultsWrapper<TimeEntry> getTimeEntries(Map<String, String> parameters) throws RedmineException {
        return DirectObjectsSearcher.getObjectsListNoPaging(this.transport, parameters, TimeEntry.class);
    }

    public TimeEntry createTimeEntry(TimeEntry obj) throws RedmineException {
        this.validate(obj);
        return this.transport.addObject(obj, new NameValuePair[0]);
    }

    private void validate(TimeEntry obj) {
        if (!obj.isValid()) {
            throw new IllegalArgumentException("You have to either define a Project or Issue ID for a Time Entry. The given Time Entry object has neither defined.");
        }
    }

    public void deleteTimeEntry(Integer id) throws RedmineException {
        this.transport.deleteObject(TimeEntry.class, Integer.toString(id));
    }

    public List<TimeEntryActivity> getTimeEntryActivities() throws RedmineException {
        return this.transport.getObjectsList(TimeEntryActivity.class, new NameValuePair[0]);
    }

    public void update(TimeEntry obj) throws RedmineException {
        this.validate(obj);
        this.transport.updateObject(obj, new NameValuePair[0]);
    }
}

