/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.WikiPage;
import com.taskadapter.redmineapi.bean.WikiPageDetail;
import com.taskadapter.redmineapi.internal.Transport;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class WikiManager {
    private final Transport transport;

    WikiManager(Transport transport) {
        this.transport = transport;
    }

    public List<WikiPage> getWikiPagesByProject(String projectKey) throws RedmineException {
        return this.transport.getChildEntries(Project.class, projectKey, WikiPage.class);
    }

    public WikiPageDetail getWikiPageDetailByProjectAndTitle(String projectKey, String pageTitle) throws RedmineException {
        String urlSafeString = WikiManager.getUrlSafeString(pageTitle);
        return this.transport.getChildEntry(Project.class, projectKey, WikiPageDetail.class, urlSafeString, new NameValuePair[]{new BasicNameValuePair("include", "attachments")});
    }

    public void create(String projectKey, WikiPageDetail detail) throws RedmineException {
        this.update(projectKey, detail);
    }

    public void update(String projectKey, WikiPageDetail detail) throws RedmineException {
        String urlSafeTitle = WikiManager.getUrlSafeString(detail.getTitle());
        this.transport.updateChildEntry(Project.class, projectKey, detail, urlSafeTitle, new NameValuePair[0]);
    }

    private static String getUrlSafeString(String string) {
        String urlSafeTitle;
        try {
            urlSafeTitle = URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UnsupportedEncodingException when converting the page title to url: " + e.toString(), e);
        }
        return urlSafeTitle;
    }
}

