/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.bean;

import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.Group;
import com.taskadapter.redmineapi.bean.Identifiable;
import com.taskadapter.redmineapi.bean.Membership;
import com.taskadapter.redmineapi.bean.Property;
import com.taskadapter.redmineapi.bean.PropertyStorage;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class User
implements Identifiable {
    public static final Integer STATUS_LOCKED = 3;
    public static final Integer STATUS_ACTIVE = 1;
    private final PropertyStorage storage = new PropertyStorage();
    public static final Property<Integer> ID = new Property<Integer>(Integer.class, "id");
    public static final Property<String> LOGIN = new Property<String>(String.class, "login");
    public static final Property<String> PASSWORD = new Property<String>(String.class, "password");
    public static final Property<String> FIRST_NAME = new Property<String>(String.class, "firstName");
    public static final Property<String> LAST_NAME = new Property<String>(String.class, "lastName");
    public static final Property<String> MAIL = new Property<String>(String.class, "mail");
    public static final Property<String> API_KEY = new Property<String>(String.class, "apiKey");
    public static final Property<Date> CREATED_ON = new Property<Date>(Date.class, "createdOn");
    public static final Property<Date> LAST_LOGIN_ON = new Property<Date>(Date.class, "lastLoginOn");
    public static final Property<Integer> AUTH_SOURCE_ID = new Property<Integer>(Integer.class, "authSourceId");
    public static final Property<Integer> STATUS = new Property<Integer>(Integer.class, "status");
    public static final Property<Set<CustomField>> CUSTOM_FIELDS = new Property<Set>(Set.class, "customFields");
    public static final Property<Set<Membership>> MEMBERSHIP = new Property<Set>(Set.class, "membership");
    public static final Property<Set<Group>> GROUPS = new Property<Set>(Set.class, "groups");

    public User(Integer id) {
        this();
        this.storage.set(ID, id);
    }

    public User() {
        this.initCollections();
    }

    private void initCollections() {
        this.storage.set(CUSTOM_FIELDS, new HashSet());
        this.storage.set(MEMBERSHIP, new HashSet());
        this.storage.set(GROUPS, new HashSet());
    }

    @Override
    public Integer getId() {
        return this.storage.get(ID);
    }

    public String toString() {
        return this.getLogin();
    }

    public String getLogin() {
        return this.storage.get(LOGIN);
    }

    public void setLogin(String login) {
        this.storage.set(LOGIN, login);
    }

    public String getFirstName() {
        return this.storage.get(FIRST_NAME);
    }

    public void setFirstName(String firstName) {
        this.storage.set(FIRST_NAME, firstName);
    }

    public String getLastName() {
        return this.storage.get(LAST_NAME);
    }

    public void setLastName(String lastName) {
        this.storage.set(LAST_NAME, lastName);
    }

    public String getMail() {
        return this.storage.get(MAIL);
    }

    public void setMail(String mail) {
        this.storage.set(MAIL, mail);
    }

    public Date getCreatedOn() {
        return this.storage.get(CREATED_ON);
    }

    public void setCreatedOn(Date createdOn) {
        this.storage.set(CREATED_ON, createdOn);
    }

    public Date getLastLoginOn() {
        return this.storage.get(LAST_LOGIN_ON);
    }

    public void setLastLoginOn(Date lastLoginOn) {
        this.storage.set(LAST_LOGIN_ON, lastLoginOn);
    }

    public String getApiKey() {
        return this.storage.get(API_KEY);
    }

    @Deprecated
    public void setApiKey(String apiKey) {
        this.storage.set(API_KEY, apiKey);
    }

    @Deprecated
    public Integer getAuthSourceId() {
        return this.storage.get(AUTH_SOURCE_ID);
    }

    public void setAuthSourceId(Integer authSource) {
        this.storage.set(AUTH_SOURCE_ID, authSource);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.getId() != null ? this.getId().equals(user.getId()) : user.getId() == null;
    }

    public int hashCode() {
        return this.getId() != null ? this.getId().hashCode() : 0;
    }

    public String getFullName() {
        String lastNameOrEmpty = this.getLastName() == null ? "" : " " + this.getLastName();
        return this.getFirstName() + lastNameOrEmpty;
    }

    public void setFullName(String fullName) {
        int ind = fullName.indexOf(32);
        if (ind != -1) {
            this.setFirstName(fullName.substring(0, ind));
            this.setLastName(fullName.substring(ind + 1));
        } else {
            this.setFirstName(fullName);
        }
    }

    public String getPassword() {
        return this.storage.get(PASSWORD);
    }

    public void setPassword(String password) {
        this.storage.set(PASSWORD, password);
    }

    public String getCustomField(String fieldName) {
        for (CustomField f : this.getCustomFields()) {
            if (!f.getName().equals(fieldName)) continue;
            return f.getValue();
        }
        return null;
    }

    public Collection<CustomField> getCustomFields() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(CUSTOM_FIELDS));
    }

    public void clearCustomFields() {
        this.storage.set(CUSTOM_FIELDS, new HashSet());
    }

    public void addCustomFields(Collection<CustomField> customFields) {
        this.storage.get(CUSTOM_FIELDS).addAll(customFields);
    }

    public void addCustomField(CustomField customField) {
        this.storage.get(CUSTOM_FIELDS).add(customField);
    }

    public Collection<Membership> getMemberships() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(MEMBERSHIP));
    }

    public void addMemberships(Collection<Membership> memberships) {
        this.storage.get(MEMBERSHIP).addAll(memberships);
    }

    public Collection<Group> getGroups() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(GROUPS));
    }

    public void addGroups(Collection<Group> groups) {
        if (!this.storage.isPropertySet(GROUPS)) {
            this.storage.set(GROUPS, new HashSet());
        }
        this.storage.get(GROUPS).addAll(groups);
    }

    public Integer getStatus() {
        return this.storage.get(STATUS);
    }

    public void setStatus(Integer status) {
        this.storage.set(STATUS, status);
    }

    public PropertyStorage getStorage() {
        return this.storage;
    }
}

