/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.bean;

import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.Group;
import com.taskadapter.redmineapi.bean.Identifiable;
import com.taskadapter.redmineapi.bean.Membership;
import com.taskadapter.redmineapi.bean.Property;
import com.taskadapter.redmineapi.bean.PropertyStorage;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class User
implements Identifiable {
    public static final Integer STATUS_ANONYMOUS = 0;
    public static final Integer STATUS_ACTIVE = 1;
    public static final Integer STATUS_REGISTERED = 2;
    public static final Integer STATUS_LOCKED = 3;
    private final PropertyStorage storage = new PropertyStorage();
    public static final Property<Integer> ID = new Property<Integer>(Integer.class, "id");
    public static final Property<String> LOGIN = new Property<String>(String.class, "login");
    public static final Property<String> PASSWORD = new Property<String>(String.class, "password");
    public static final Property<String> FIRST_NAME = new Property<String>(String.class, "firstName");
    public static final Property<String> LAST_NAME = new Property<String>(String.class, "lastName");
    public static final Property<String> MAIL = new Property<String>(String.class, "mail");
    public static final Property<String> API_KEY = new Property<String>(String.class, "apiKey");
    public static final Property<Date> CREATED_ON = new Property<Date>(Date.class, "createdOn");
    public static final Property<Date> LAST_LOGIN_ON = new Property<Date>(Date.class, "lastLoginOn");
    public static final Property<Integer> AUTH_SOURCE_ID = new Property<Integer>(Integer.class, "authSourceId");
    public static final Property<Integer> STATUS = new Property<Integer>(Integer.class, "status");
    public static final Property<String> MAIL_NOTIFICATION = new Property<String>(String.class, "mail_notification");
    public static final Property<Boolean> MUST_CHANGE_PASSWD = new Property<Boolean>(Boolean.class, "must_change_passwd");
    public static final Property<Boolean> GENERATE_PASSWORD = new Property<Boolean>(Boolean.class, "generate_password");
    public static final Property<Set<CustomField>> CUSTOM_FIELDS = new Property<Set>(Set.class, "customFields");
    public static final Property<Set<Membership>> MEMBERSHIP = new Property<Set>(Set.class, "membership");
    public static final Property<Set<Group>> GROUPS = new Property<Set>(Set.class, "groups");

    public User(Integer id) {
        this();
        this.storage.set(ID, id);
    }

    public User() {
        this.initCollections();
    }

    private void initCollections() {
        this.storage.set(CUSTOM_FIELDS, new HashSet());
        this.storage.set(MEMBERSHIP, new HashSet());
        this.storage.set(GROUPS, new HashSet());
    }

    @Override
    public Integer getId() {
        return this.storage.get(ID);
    }

    public String toString() {
        return this.getLogin();
    }

    public String getLogin() {
        return this.storage.get(LOGIN);
    }

    public User setLogin(String login) {
        this.storage.set(LOGIN, login);
        return this;
    }

    public String getFirstName() {
        return this.storage.get(FIRST_NAME);
    }

    public User setFirstName(String firstName) {
        this.storage.set(FIRST_NAME, firstName);
        return this;
    }

    public String getLastName() {
        return this.storage.get(LAST_NAME);
    }

    public User setLastName(String lastName) {
        this.storage.set(LAST_NAME, lastName);
        return this;
    }

    public String getMail() {
        return this.storage.get(MAIL);
    }

    public User setMail(String mail) {
        this.storage.set(MAIL, mail);
        return this;
    }

    public Date getCreatedOn() {
        return this.storage.get(CREATED_ON);
    }

    public User setCreatedOn(Date createdOn) {
        this.storage.set(CREATED_ON, createdOn);
        return this;
    }

    public Date getLastLoginOn() {
        return this.storage.get(LAST_LOGIN_ON);
    }

    public User setLastLoginOn(Date lastLoginOn) {
        this.storage.set(LAST_LOGIN_ON, lastLoginOn);
        return this;
    }

    public String getApiKey() {
        return this.storage.get(API_KEY);
    }

    @Deprecated
    public User setApiKey(String apiKey) {
        this.storage.set(API_KEY, apiKey);
        return this;
    }

    @Deprecated
    public Integer getAuthSourceId() {
        return this.storage.get(AUTH_SOURCE_ID);
    }

    public User setAuthSourceId(Integer authSource) {
        this.storage.set(AUTH_SOURCE_ID, authSource);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.getId() != null ? this.getId().equals(user.getId()) : user.getId() == null;
    }

    public int hashCode() {
        return this.getId() != null ? this.getId().hashCode() : 0;
    }

    public String getFullName() {
        String lastNameOrEmpty = this.getLastName() == null ? "" : " " + this.getLastName();
        return this.getFirstName() + lastNameOrEmpty;
    }

    public User setFullName(String fullName) {
        int ind = fullName.indexOf(32);
        if (ind != -1) {
            this.setFirstName(fullName.substring(0, ind));
            this.setLastName(fullName.substring(ind + 1));
        } else {
            this.setFirstName(fullName);
        }
        return this;
    }

    public String getPassword() {
        return this.storage.get(PASSWORD);
    }

    public User setPassword(String password) {
        this.storage.set(PASSWORD, password);
        return this;
    }

    public String getCustomField(String fieldName) {
        for (CustomField f : this.getCustomFields()) {
            if (!f.getName().equals(fieldName)) continue;
            return f.getValue();
        }
        return null;
    }

    public Collection<CustomField> getCustomFields() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(CUSTOM_FIELDS));
    }

    public void clearCustomFields() {
        this.storage.set(CUSTOM_FIELDS, new HashSet());
    }

    public User addCustomFields(Collection<CustomField> customFields) {
        this.storage.get(CUSTOM_FIELDS).addAll(customFields);
        return this;
    }

    public User addCustomField(CustomField customField) {
        this.storage.get(CUSTOM_FIELDS).add(customField);
        return this;
    }

    public Collection<Membership> getMemberships() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(MEMBERSHIP));
    }

    public User addMemberships(Collection<Membership> memberships) {
        this.storage.get(MEMBERSHIP).addAll(memberships);
        return this;
    }

    public Collection<Group> getGroups() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(GROUPS));
    }

    public User addGroups(Collection<Group> groups) {
        if (!this.storage.isPropertySet(GROUPS)) {
            this.storage.set(GROUPS, new HashSet());
        }
        this.storage.get(GROUPS).addAll(groups);
        return this;
    }

    public Integer getStatus() {
        return this.storage.get(STATUS);
    }

    public User setStatus(Integer status) {
        this.storage.set(STATUS, status);
        return this;
    }

    public User setMailNotification(String mailNotification) {
        this.storage.set(MAIL_NOTIFICATION, mailNotification);
        return this;
    }

    public User setMustChangePasswd(Boolean mustChangePasswd) {
        this.storage.set(MUST_CHANGE_PASSWD, mustChangePasswd);
        return this;
    }

    public User setGeneratePassword(Boolean generatePassword) {
        this.storage.set(GENERATE_PASSWORD, generatePassword);
        return this;
    }

    public PropertyStorage getStorage() {
        return this.storage;
    }
}

