/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.dbauth.internal;

import com.google.protobuf.InvalidProtocolBufferException;
import com.tencentcloud.dbauth.model.AuthTokenInfoOuterClass;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class AuthTokenParser {
    public static AuthTokenInfoOuterClass.AuthTokenInfo parseAuthToken(String instanceId, String region, String userName, String token) throws Exception {
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{instanceId, region, userName, token})) {
            throw new Exception("param empty");
        }
        String seedKey = AuthTokenParser.sha256((instanceId + "_" + region + "_" + userName).getBytes());
        String key = seedKey.substring(0, 32);
        String iv = seedKey.substring(33, 49);
        byte[] decToken = AuthTokenParser.decrypt(token.substring(64), key, iv);
        String tokenHash = AuthTokenParser.sha256(decToken);
        if (!token.substring(0, 64).equals(tokenHash)) {
            throw new Exception("token not compare");
        }
        return AuthTokenParser.getAuthTokenInfo(decToken);
    }

    private static AuthTokenInfoOuterClass.AuthTokenInfo getAuthTokenInfo(byte[] decToken) throws Exception {
        AuthTokenInfoOuterClass.AuthTokenInfo tokenInfo;
        byte[] subToken = Arrays.copyOfRange(decToken, 4, decToken.length);
        try {
            tokenInfo = AuthTokenInfoOuterClass.AuthTokenInfo.parseFrom(subToken);
        }
        catch (InvalidProtocolBufferException e) {
            throw new Exception("Failed to parse AuthTokenInfo", e);
        }
        return tokenInfo;
    }

    public static String sha256(byte[] base) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(base);
        StringBuilder hexString = new StringBuilder();
        for (byte b : hash) {
            String hex = String.format("%02x", b);
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private static byte[] decrypt(String input, String key, String iv) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)new SecretKeySpec(key.getBytes(), "AES"), new IvParameterSpec(iv.getBytes()));
        return cipher.doFinal(AuthTokenParser.base64Decode(input));
    }

    private static byte[] base64Decode(String string) {
        String data = string.replace("-", "+").replace("_", "/");
        int mod4 = data.length() % 4;
        if (mod4 != 0) {
            data = data + "====".substring(mod4);
        }
        return Base64.getDecoder().decode(data);
    }
}

