/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.dbauth.internal;

import com.tencentcloud.dbauth.internal.AuthTokenParser;
import com.tencentcloud.dbauth.internal.ErrorCodeMatcher;
import com.tencentcloud.dbauth.internal.TimerManager;
import com.tencentcloud.dbauth.internal.Token;
import com.tencentcloud.dbauth.internal.TokenCache;
import com.tencentcloud.dbauth.model.AuthTokenInfoOuterClass;
import com.tencentcloud.dbauth.model.GenerateAuthenticationTokenRequest;
import com.tencentcloudapi.cam.v20190116.CamClient;
import com.tencentcloudapi.cam.v20190116.CamErrorCode;
import com.tencentcloudapi.cam.v20190116.models.AuthToken;
import com.tencentcloudapi.cam.v20190116.models.BuildDataFlowAuthTokenRequest;
import com.tencentcloudapi.cam.v20190116.models.BuildDataFlowAuthTokenResponse;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.HttpProfile;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Signer {
    private static final Logger log = LoggerFactory.getLogger(Signer.class);
    private static final TokenCache TOKEN_CACHE = new TokenCache();
    private static final TimerManager TIMER_MANAGER = new TimerManager();
    private static final long TOKEN_UPDATE_INTERVAL = 5000L;
    private final GenerateAuthenticationTokenRequest request;
    private final String authKey;

    public Signer(GenerateAuthenticationTokenRequest request) {
        this.request = request;
        String key = request.region() + "_" + request.instanceId() + "_" + request.userName() + "_" + request.credential().getSecretId();
        this.authKey = Base64.getEncoder().encodeToString(key.getBytes());
    }

    private static long getDelayForNextTokenUpdate(long remainingTimeBeforeExpiry) {
        return Math.min(remainingTimeBeforeExpiry, 5000L);
    }

    public Token getAuthTokenFromCache() {
        return TOKEN_CACHE.getAuthToken(this.authKey);
    }

    public void buildAuthToken() throws TencentCloudSDKException {
        log.debug("Building authentication token for key");
        try {
            Token token = this.getAuthToken();
            this.setTokenAndUpdateTask(token);
        }
        catch (TencentCloudSDKException e) {
            if (ErrorCodeMatcher.isUserNotificationRequired(e.getErrorCode())) {
                throw e;
            }
            Token fallbackToken = TOKEN_CACHE.fallback(this.authKey);
            if (fallbackToken != null) {
                log.info("Using the fallback token");
                this.setTokenAndUpdateTask(fallbackToken);
            }
            throw e;
        }
    }

    private void setTokenAndUpdateTask(Token token) {
        TOKEN_CACHE.setAuthToken(this.authKey, token);
        this.updateAuthTokenTask(token.getExpires());
    }

    public Token getAuthToken() throws TencentCloudSDKException {
        BuildDataFlowAuthTokenResponse response = this.requestAuthToken();
        if (response == null) {
            log.error("Failed to request AuthToken, response is null");
            throw new TencentCloudSDKException("Failed to request AuthToken, response is null", "", CamErrorCode.INTERNALERROR.getValue());
        }
        String requestId = response.getRequestId();
        if (response.getCredentials() == null) {
            log.error("Failed to request AuthToken, tokenResponse is null, requestId: {}", (Object)requestId);
            throw new TencentCloudSDKException("Failed to request AuthToken, tokenResponse is null", requestId, CamErrorCode.INTERNALERROR.getValue());
        }
        AuthToken tokenResponse = response.getCredentials();
        String encAuthToken = tokenResponse.getToken();
        String authToken = null;
        try {
            authToken = this.decryptAuthToken(encAuthToken);
        }
        catch (Exception e) {
            String errorMsg = "Failed to decrypt AuthToken, requestId: " + requestId + ", error: " + e.getMessage();
            log.error(errorMsg);
            throw new TencentCloudSDKException(errorMsg, requestId, CamErrorCode.INTERNALERROR.getValue());
        }
        if (StringUtils.isEmpty((CharSequence)authToken)) {
            log.error("Failed to decrypt AuthToken, authToken is empty, requestId: {}", (Object)requestId);
            throw new TencentCloudSDKException("Failed to decrypt AuthToken, authToken is empty", requestId, CamErrorCode.INTERNALERROR.getValue());
        }
        long camServerTime = tokenResponse.getCurrentTime();
        long authTokenExpires = tokenResponse.getNextRotationTime();
        long expiry = this.expiry(camServerTime, authTokenExpires);
        return new Token(authToken, expiry);
    }

    private String decryptAuthToken(String encAuthToken) throws Exception {
        AuthTokenInfoOuterClass.AuthTokenInfo tokenInfo = AuthTokenParser.parseAuthToken(this.request.instanceId(), this.request.region(), this.request.userName(), encAuthToken);
        return tokenInfo.getPassword();
    }

    private long expiry(long camServerTime, long authTokenExpires) {
        if (authTokenExpires < camServerTime) {
            return System.currentTimeMillis() + 5000L;
        }
        return System.currentTimeMillis() + (authTokenExpires - camServerTime);
    }

    private BuildDataFlowAuthTokenResponse requestAuthToken() throws TencentCloudSDKException {
        BuildDataFlowAuthTokenRequest req = new BuildDataFlowAuthTokenRequest();
        req.setResourceId(this.request.instanceId());
        req.setResourceRegion(this.request.region());
        req.setResourceAccount(this.request.userName());
        CamClient client = new CamClient(this.request.credential(), this.request.region());
        HttpProfile httpProfile = client.getClientProfile().getHttpProfile();
        httpProfile.setWriteTimeout(30);
        httpProfile.setReadTimeout(30);
        TencentCloudSDKException lastException = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return client.BuildDataFlowAuthToken(req);
            }
            catch (TencentCloudSDKException e) {
                lastException = e;
                if (ErrorCodeMatcher.isUserNotificationRequired(e.getErrorCode())) {
                    log.error("Failed to request AuthToken, error: {}", (Object)e.toString());
                    break;
                }
                log.error("Failed to request AuthToken, Retry to request the token, error: {}", (Object)e.toString());
                continue;
            }
            catch (Exception e) {
                log.error("Failed to request AuthToken , error: {}", (Object)e.getMessage());
                lastException = new TencentCloudSDKException("Failed to request AuthToken, error: " + e.getMessage(), "", CamErrorCode.INTERNALERROR.getValue());
            }
        }
        throw lastException;
    }

    private void updateAuthTokenTask(long authTokenExpiry) {
        long remainingTimeBeforeExpiry = authTokenExpiry - System.currentTimeMillis();
        long delayForNextTokenUpdate = Signer.getDelayForNextTokenUpdate(remainingTimeBeforeExpiry);
        log.debug("Scheduling next token key update in {} ms, token remaining time: {} ms", (Object)delayForNextTokenUpdate, (Object)remainingTimeBeforeExpiry);
        TIMER_MANAGER.saveTimer(this.authKey, delayForNextTokenUpdate, () -> {
            try {
                this.buildAuthToken();
            }
            catch (TencentCloudSDKException e) {
                if (ErrorCodeMatcher.isUserNotificationRequired(e.getErrorCode())) {
                    log.error("Failed to update the authentication token", (Throwable)e);
                    TOKEN_CACHE.removeAuthToken(this.authKey);
                }
                log.error("Failed to update the authentication token, Retry to update the token", (Throwable)e);
                this.updateAuthTokenTask(System.currentTimeMillis() + 5000L);
            }
        });
    }
}

