/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.dbauth.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

public final class TimerManager {
    private static final int CORE_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    private final ConcurrentHashMap<String, ScheduledFuture<?>> timerMap = new ConcurrentHashMap();
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(CORE_POOL_SIZE, new ThreadFactory(){
        private final AtomicInteger counter = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("ScheduledThread-" + this.counter.incrementAndGet());
            return thread;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTimer(String key, long delay, Runnable task) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
        if (delay <= 0L || delay > 86400000L) {
            return;
        }
        TimerManager timerManager = this;
        synchronized (timerManager) {
            ScheduledFuture<?> newFuture = this.executor.schedule(task, delay, TimeUnit.MILLISECONDS);
            ScheduledFuture<?> future = this.timerMap.remove(key);
            if (future != null) {
                future.cancel(true);
            }
            this.timerMap.put(key, newFuture);
        }
    }
}

