/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.dbauth.internal;

import com.tencentcloud.dbauth.internal.Token;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenCache {
    private static final Logger log = LoggerFactory.getLogger(TokenCache.class);
    private static final long MAX_PASSWORD_SIZE = 200L;
    private static final long MAX_FILE_VALID_TIME = 86400000L;
    private final ConcurrentHashMap<String, Token> tokenMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Long> fileLastModifyTimeMap = new ConcurrentHashMap();

    public Token getAuthToken(String key) {
        return this.tokenMap.get(key);
    }

    public void setAuthToken(String key, Token token) {
        if (StringUtils.isEmpty((CharSequence)key) || token == null) {
            return;
        }
        this.tokenMap.put(key, token);
    }

    public void removeAuthToken(String key) {
        this.tokenMap.remove(key);
    }

    private Long getFileLastModifyTime(String key) {
        return this.fileLastModifyTimeMap.get(key);
    }

    private void setFileLastModifyTime(String key, Long lastModifyTime) {
        this.fileLastModifyTimeMap.put(key, lastModifyTime);
    }

    public Token fallback(String authKey) {
        Path inputFilePath = this.generateInputFilePath(authKey);
        if (inputFilePath == null) {
            return null;
        }
        if (Files.exists(inputFilePath, new LinkOption[0])) {
            try {
                log.debug("file name: {}, file size: {}", (Object)inputFilePath, (Object)Files.size(inputFilePath));
                if (Files.size(inputFilePath) == 0L) {
                    return null;
                }
                if (Files.size(inputFilePath) > 200L) {
                    log.error("The file size is greater than 200, skip the file: {}", (Object)inputFilePath);
                    return null;
                }
                List<String> lines = Files.readAllLines(inputFilePath);
                if (lines.size() == 0) {
                    return null;
                }
                if (lines.size() > 1) {
                    log.error("The file has more than one line, skip the file: {}", (Object)inputFilePath);
                    return null;
                }
                String password = lines.get(0);
                if (StringUtils.isEmpty((CharSequence)password)) {
                    return null;
                }
                Long fileLastModifyTime = Files.getLastModifiedTime(inputFilePath, new LinkOption[0]).toMillis();
                if (System.currentTimeMillis() - fileLastModifyTime > 86400000L) {
                    log.debug("The file has been updated for more than 24 hours, skip the file: {}", (Object)inputFilePath);
                    return null;
                }
                if (fileLastModifyTime.equals(this.getFileLastModifyTime(inputFilePath.toString()))) {
                    log.debug("The password has not been updated, skip the file: {}", (Object)inputFilePath);
                    return null;
                }
                log.info("Reading the password from the file: {}", (Object)inputFilePath);
                this.setFileLastModifyTime(inputFilePath.toString(), fileLastModifyTime);
                return new Token(password, System.currentTimeMillis() + 86400000L);
            }
            catch (Exception e) {
                log.error("Failed to read the password from the file: {}", (Object)inputFilePath, (Object)e);
            }
        }
        return null;
    }

    private Path generateInputFilePath(String tokenKey) {
        String[] keys;
        try {
            keys = new String(Base64.getDecoder().decode(tokenKey)).split("_");
        }
        catch (Exception e) {
            log.error("Failed to decode the key", (Throwable)e);
            return null;
        }
        if (keys.length != 4) {
            return null;
        }
        String region = keys[0];
        String instanceId = keys[1];
        String userName = keys[2];
        Path path = Paths.get(".com.tencentcloudapi/tencentcloud-dbauth-sdk-java/input/", new String[0]).resolve(region + "_" + instanceId + "_" + userName + ".pwd");
        return Paths.get(System.getProperty("user.dir"), path.toString());
    }
}

