/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.dbauth;

import com.tencentcloud.dbauth.internal.ErrorCodeMatcher;
import com.tencentcloud.dbauth.internal.Signer;
import com.tencentcloud.dbauth.internal.Token;
import com.tencentcloud.dbauth.model.GenerateAuthenticationTokenRequest;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBAuthentication {
    private static final Logger log = LoggerFactory.getLogger(DBAuthentication.class);

    private DBAuthentication() {
    }

    public static String generateAuthenticationToken(GenerateAuthenticationTokenRequest tokenRequest) throws TencentCloudSDKException {
        Signer signer = new Signer(tokenRequest);
        Token cachedToken = signer.getAuthTokenFromCache();
        if (cachedToken != null && cachedToken.getExpires() > System.currentTimeMillis()) {
            return cachedToken.getAuthToken();
        }
        try {
            signer.buildAuthToken();
            return signer.getAuthTokenFromCache().getAuthToken();
        }
        catch (TencentCloudSDKException e) {
            log.error("Error occurred while generating authentication token", (Throwable)e);
            if (cachedToken != null) {
                if (ErrorCodeMatcher.isUserNotificationRequired(e.getErrorCode())) {
                    throw e;
                }
                return cachedToken.getAuthToken();
            }
            throw e;
        }
    }
}

