/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.CircuitBreaker;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import java.io.Closeable;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Scanner;
import okhttp3.Response;
import okhttp3.ResponseBody;

public abstract class SSEResponseModel
extends AbstractModel
implements Iterable<SSE>,
Closeable {
    private Response response;
    private CircuitBreaker.Token token;

    public abstract String getRequestId();

    public abstract void setRequestId(String var1);

    public void setResponse(Response response) {
        this.response = response;
    }

    @Override
    public boolean isStream() {
        return this.response != null;
    }

    public void setToken(CircuitBreaker.Token token) {
        this.token = token;
    }

    @Override
    public Iterator<SSE> iterator() {
        try {
            return new SSEIterator(this);
        }
        catch (TencentCloudSDKException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void toMap(HashMap<String, String> map, String prefix) {
    }

    @Override
    public void close() {
        this.response.close();
    }

    private static class SSEIterator
    implements Iterator<SSE> {
        private final Scanner scanner;

        public SSEIterator(SSEResponseModel resp) throws TencentCloudSDKException {
            ResponseBody body = resp.response.body();
            if (body == null) {
                throw new TencentCloudSDKException("Response body should not be null");
            }
            this.scanner = new Scanner((ReadableByteChannel)body.source(), StandardCharsets.UTF_8.name());
        }

        @Override
        public boolean hasNext() {
            return this.scanner.hasNextLine();
        }

        @Override
        public SSE next() {
            String line;
            SSE e = new SSE();
            StringBuilder sb = new StringBuilder();
            while (!(line = this.scanner.nextLine()).isEmpty()) {
                String key;
                if (line.charAt(0) == ':') continue;
                int colonIdx = line.indexOf(58);
                switch (key = line.substring(0, colonIdx)) {
                    case "id": {
                        e.Id = line.substring(colonIdx + 1);
                        break;
                    }
                    case "event": {
                        e.Event = line.substring(colonIdx + 1);
                        break;
                    }
                    case "data": {
                        if (sb.length() > 0) {
                            sb.append('\n');
                        }
                        if ((line = line.substring(colonIdx + 1)).charAt(0) == ' ') {
                            line = line.substring(1);
                        }
                        sb.append(line);
                        break;
                    }
                    case "retry": {
                        e.Retry = Integer.parseInt(line.substring(colonIdx + 1));
                    }
                }
            }
            e.Data = sb.toString();
            return e;
        }

        @Override
        public void remove() {
        }
    }

    public static class SSE {
        public String Id;
        public String Event;
        public String Data;
        public long Retry;

        public String toString() {
            return String.format("Id=%s Event=%s Retry=%d Data=%s", this.Id, this.Event, this.Retry, this.Data);
        }
    }
}

