/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.csip.v20221121.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class TaskAssetObject extends AbstractModel{

    /**
    * 资产名
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("AssetName")
    @Expose
    private String AssetName;

    /**
    * 	资产类型
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("InstanceType")
    @Expose
    private String InstanceType;

    /**
    * 资产分类
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("AssetType")
    @Expose
    private String AssetType;

    /**
    * ip/域名/资产id，数据库id等
    */
    @SerializedName("Asset")
    @Expose
    private String Asset;

    /**
    * 地域
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Region")
    @Expose
    private String Region;

    /**
    * 多云资产唯一id
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("Arn")
    @Expose
    private String Arn;

    /**
     * Get 资产名
注意：此字段可能返回 null，表示取不到有效值。 
     * @return AssetName 资产名
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getAssetName() {
        return this.AssetName;
    }

    /**
     * Set 资产名
注意：此字段可能返回 null，表示取不到有效值。
     * @param AssetName 资产名
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setAssetName(String AssetName) {
        this.AssetName = AssetName;
    }

    /**
     * Get 	资产类型
注意：此字段可能返回 null，表示取不到有效值。 
     * @return InstanceType 	资产类型
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getInstanceType() {
        return this.InstanceType;
    }

    /**
     * Set 	资产类型
注意：此字段可能返回 null，表示取不到有效值。
     * @param InstanceType 	资产类型
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setInstanceType(String InstanceType) {
        this.InstanceType = InstanceType;
    }

    /**
     * Get 资产分类
注意：此字段可能返回 null，表示取不到有效值。 
     * @return AssetType 资产分类
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getAssetType() {
        return this.AssetType;
    }

    /**
     * Set 资产分类
注意：此字段可能返回 null，表示取不到有效值。
     * @param AssetType 资产分类
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setAssetType(String AssetType) {
        this.AssetType = AssetType;
    }

    /**
     * Get ip/域名/资产id，数据库id等 
     * @return Asset ip/域名/资产id，数据库id等
     */
    public String getAsset() {
        return this.Asset;
    }

    /**
     * Set ip/域名/资产id，数据库id等
     * @param Asset ip/域名/资产id，数据库id等
     */
    public void setAsset(String Asset) {
        this.Asset = Asset;
    }

    /**
     * Get 地域
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Region 地域
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getRegion() {
        return this.Region;
    }

    /**
     * Set 地域
注意：此字段可能返回 null，表示取不到有效值。
     * @param Region 地域
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setRegion(String Region) {
        this.Region = Region;
    }

    /**
     * Get 多云资产唯一id
注意：此字段可能返回 null，表示取不到有效值。 
     * @return Arn 多云资产唯一id
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String getArn() {
        return this.Arn;
    }

    /**
     * Set 多云资产唯一id
注意：此字段可能返回 null，表示取不到有效值。
     * @param Arn 多云资产唯一id
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setArn(String Arn) {
        this.Arn = Arn;
    }

    public TaskAssetObject() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public TaskAssetObject(TaskAssetObject source) {
        if (source.AssetName != null) {
            this.AssetName = new String(source.AssetName);
        }
        if (source.InstanceType != null) {
            this.InstanceType = new String(source.InstanceType);
        }
        if (source.AssetType != null) {
            this.AssetType = new String(source.AssetType);
        }
        if (source.Asset != null) {
            this.Asset = new String(source.Asset);
        }
        if (source.Region != null) {
            this.Region = new String(source.Region);
        }
        if (source.Arn != null) {
            this.Arn = new String(source.Arn);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "AssetName", this.AssetName);
        this.setParamSimple(map, prefix + "InstanceType", this.InstanceType);
        this.setParamSimple(map, prefix + "AssetType", this.AssetType);
        this.setParamSimple(map, prefix + "Asset", this.Asset);
        this.setParamSimple(map, prefix + "Region", this.Region);
        this.setParamSimple(map, prefix + "Arn", this.Arn);

    }
}

