/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.vod.v20180717.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class VerifyDomainRecordRequest extends AbstractModel{

    /**
    * 需要接入点播的加速域名。
    */
    @SerializedName("Domain")
    @Expose
    private String Domain;

    /**
    * 验证方式：
<li>dns：DNS 解析验证；</li>
<li>fIle：文件验证。</li>

默认值：dns。
    */
    @SerializedName("VerifyType")
    @Expose
    private String VerifyType;

    /**
     * Get 需要接入点播的加速域名。 
     * @return Domain 需要接入点播的加速域名。
     */
    public String getDomain() {
        return this.Domain;
    }

    /**
     * Set 需要接入点播的加速域名。
     * @param Domain 需要接入点播的加速域名。
     */
    public void setDomain(String Domain) {
        this.Domain = Domain;
    }

    /**
     * Get 验证方式：
<li>dns：DNS 解析验证；</li>
<li>fIle：文件验证。</li>

默认值：dns。 
     * @return VerifyType 验证方式：
<li>dns：DNS 解析验证；</li>
<li>fIle：文件验证。</li>

默认值：dns。
     */
    public String getVerifyType() {
        return this.VerifyType;
    }

    /**
     * Set 验证方式：
<li>dns：DNS 解析验证；</li>
<li>fIle：文件验证。</li>

默认值：dns。
     * @param VerifyType 验证方式：
<li>dns：DNS 解析验证；</li>
<li>fIle：文件验证。</li>

默认值：dns。
     */
    public void setVerifyType(String VerifyType) {
        this.VerifyType = VerifyType;
    }

    public VerifyDomainRecordRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public VerifyDomainRecordRequest(VerifyDomainRecordRequest source) {
        if (source.Domain != null) {
            this.Domain = new String(source.Domain);
        }
        if (source.VerifyType != null) {
            this.VerifyType = new String(source.VerifyType);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Domain", this.Domain);
        this.setParamSimple(map, prefix + "VerifyType", this.VerifyType);

    }
}

