/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.wedata.v20210820.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeInstanceLogListResponse extends AbstractModel{

    /**
    * 日志列表
    */
    @SerializedName("Data")
    @Expose
    private String Data;

    /**
    * 日志列表
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("InstanceLogList")
    @Expose
    private InstanceLogList [] InstanceLogList;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 日志列表 
     * @return Data 日志列表
     */
    public String getData() {
        return this.Data;
    }

    /**
     * Set 日志列表
     * @param Data 日志列表
     */
    public void setData(String Data) {
        this.Data = Data;
    }

    /**
     * Get 日志列表
注意：此字段可能返回 null，表示取不到有效值。 
     * @return InstanceLogList 日志列表
注意：此字段可能返回 null，表示取不到有效值。
     */
    public InstanceLogList [] getInstanceLogList() {
        return this.InstanceLogList;
    }

    /**
     * Set 日志列表
注意：此字段可能返回 null，表示取不到有效值。
     * @param InstanceLogList 日志列表
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setInstanceLogList(InstanceLogList [] InstanceLogList) {
        this.InstanceLogList = InstanceLogList;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeInstanceLogListResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeInstanceLogListResponse(DescribeInstanceLogListResponse source) {
        if (source.Data != null) {
            this.Data = new String(source.Data);
        }
        if (source.InstanceLogList != null) {
            this.InstanceLogList = new InstanceLogList[source.InstanceLogList.length];
            for (int i = 0; i < source.InstanceLogList.length; i++) {
                this.InstanceLogList[i] = new InstanceLogList(source.InstanceLogList[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Data", this.Data);
        this.setParamArrayObj(map, prefix + "InstanceLogList.", this.InstanceLogList);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

