/*
 * Decompiled with CFR 0.152.
 */
package com.testmonitor.actions;

import com.testmonitor.api.Connector;
import com.testmonitor.parsers.MilestoneParser;
import com.testmonitor.resources.Milestone;
import com.testmonitor.resources.Project;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.json.JSONObject;

public class Milestones {
    private final Connector connector;
    private final Integer projectId;

    public Milestones(Connector connector, Project project) {
        this.connector = connector;
        this.projectId = project.getId();
    }

    public ArrayList<Milestone> list() {
        return this.list(1);
    }

    public ArrayList<Milestone> list(Integer page) {
        return this.list(page, 15);
    }

    public ArrayList<Milestone> list(Integer page, Integer limit) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("page", page.toString()));
        params.add(new BasicNameValuePair("limit", limit.toString()));
        params.add(new BasicNameValuePair("project_id", this.projectId.toString()));
        return MilestoneParser.parse(this.connector.get("milestones", params));
    }

    public Milestone get(Integer id) {
        JSONObject response = this.connector.get("milestones/" + id);
        HashMap milestone = (HashMap)response.getJSONObject("data").toMap();
        return MilestoneParser.parse(milestone);
    }

    public ArrayList<Milestone> search(String search) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("query", search));
        params.add(new BasicNameValuePair("project_id", this.projectId.toString()));
        return MilestoneParser.parse(this.connector.get("milestones", params));
    }

    public Milestone create(String name) {
        Milestone milestone = new Milestone();
        milestone.setName(name);
        milestone.setEndsAt(new Date());
        milestone.setProjectId(this.projectId);
        return this.create(milestone);
    }

    public Milestone create(Milestone milestone) {
        JSONObject response = this.connector.post("milestones", milestone.toHttpParams());
        milestone.setId(response.getJSONObject("data").get("id").toString());
        return milestone;
    }

    public Milestone findOrCreate(String search) {
        ArrayList<Milestone> milestones = this.search("\"" + search + "\"");
        if (milestones.size() > 0) {
            return milestones.get(0);
        }
        return this.create(search);
    }

    public Milestone update(Milestone milestone) {
        JSONObject response = this.connector.put("milestones/" + milestone.getId(), milestone.toHttpParams());
        HashMap updatedMilestone = (HashMap)response.getJSONObject("data").toMap();
        return MilestoneParser.parse(updatedMilestone);
    }
}

