/*
 * Decompiled with CFR 0.152.
 */
package com.testmonitor.api;

import com.testmonitor.exceptions.NotFoundException;
import com.testmonitor.exceptions.ServerException;
import com.testmonitor.exceptions.UnprocessableEntityException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.json.JSONObject;

public class Connector {
    private final String token;
    private final String domain;
    private final CloseableHttpClient httpClient;

    public Connector(String domain, String token) {
        this.token = token;
        this.domain = domain;
        RequestConfig requestConfig = RequestConfig.custom().setResponseTimeout(5000L, TimeUnit.MILLISECONDS).setConnectTimeout(5000L, TimeUnit.MILLISECONDS).setConnectionRequestTimeout(5000L, TimeUnit.MILLISECONDS).setCookieSpec("ignore").build();
        this.httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).setUserAgent("TestMonitorJavaClient/1.0 (+https://www.testmonitor.com/)").build();
    }

    protected String baseUrl() {
        return "https://" + this.domain + "/api/v1/";
    }

    protected String baseUrl(String path) {
        return this.baseUrl() + path;
    }

    public JSONObject get(String uri) throws IOException {
        HttpGet httpget = new HttpGet(this.baseUrl(uri));
        return this.request(httpget);
    }

    public JSONObject get(String uri, List<NameValuePair> params) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = null;
        uriBuilder = new URIBuilder(this.baseUrl(uri));
        uriBuilder.addParameters(params);
        HttpGet httpget = new HttpGet(uriBuilder.toString());
        httpget.setEntity(new UrlEncodedFormEntity(params));
        return this.request(httpget);
    }

    public JSONObject post(String uri, List<NameValuePair> params) throws IOException {
        HttpPost httppost = new HttpPost(this.baseUrl(uri));
        httppost.setEntity(new UrlEncodedFormEntity(params));
        return this.request(httppost);
    }

    public JSONObject put(String uri, List<NameValuePair> params) throws IOException {
        HttpPut httpput = new HttpPut(this.baseUrl(uri));
        httpput.setEntity(new UrlEncodedFormEntity(params));
        return this.request(httpput);
    }

    public JSONObject multiPartPost(String uri, List<NameValuePair> params, HashMap<String, File> files) throws IOException {
        HttpPost httppost = new HttpPost(this.baseUrl(uri));
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.EXTENDED);
        params.forEach(pair -> builder.addTextBody(pair.getName(), pair.getValue()));
        files.forEach((name, file) -> builder.addPart((String)name, new FileBody((File)file, ContentType.DEFAULT_BINARY)));
        HttpEntity entity = builder.build();
        httppost.setEntity(entity);
        return this.request(httppost);
    }

    public JSONObject postFile(String uri, String name, File file) throws IOException {
        HttpPost post = new HttpPost(this.baseUrl(uri));
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.EXTENDED);
        builder.addPart(name, new FileBody(file, ContentType.DEFAULT_BINARY));
        HttpEntity entity = builder.build();
        post.setEntity(entity);
        return this.request(post);
    }

    public JSONObject request(HttpUriRequestBase httpUriRequestBase) throws IOException {
        httpUriRequestBase.setHeader("Authorization", "Bearer " + this.token);
        httpUriRequestBase.setHeader("Accept", "application/json");
        HttpClientResponseHandler<String> responseHandler = new HttpClientResponseHandler<String>(){

            @Override
            public String handleResponse(ClassicHttpResponse response) throws IOException, ParseException {
                int status = response.getCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    try {
                        return entity != null ? EntityUtils.toString(entity) : null;
                    }
                    catch (ParseException ex) {
                        throw new ClientProtocolException(ex);
                    }
                }
                if (status == 500) {
                    throw new ServerException(status, EntityUtils.toString(response.getEntity()));
                }
                if (status == 422) {
                    throw new UnprocessableEntityException(status, EntityUtils.toString(response.getEntity()));
                }
                if (status == 404) {
                    throw new NotFoundException(status, EntityUtils.toString(response.getEntity()));
                }
                throw new ClientProtocolException("Unexpected response status: " + status + "\n" + EntityUtils.toString(response.getEntity()));
            }
        };
        String responseBody = this.httpClient.execute((ClassicHttpRequest)httpUriRequestBase, responseHandler);
        return new JSONObject(responseBody);
    }
}

