/*
 * Decompiled with CFR 0.152.
 */
package com.textkernel.tx.models.job;

import com.google.gson.JsonParseException;
import com.textkernel.tx.models.Location;
import com.textkernel.tx.models.ParsedDocument;
import com.textkernel.tx.models.TxPrimitive;
import com.textkernel.tx.models.job.ApplicationDetails;
import com.textkernel.tx.models.job.EmployerNames;
import com.textkernel.tx.models.job.JobDegree;
import com.textkernel.tx.models.job.JobMetadata;
import com.textkernel.tx.models.job.JobTitles;
import com.textkernel.tx.models.job.PayRange;
import com.textkernel.tx.models.job.skills.JobTaxonomyRoot;
import com.textkernel.tx.models.job.skills.JobV2Skills;
import com.textkernel.tx.utilities.TxJsonSerializer;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.List;

public class ParsedJob
extends ParsedDocument {
    public boolean CurrentJobIsManagement;
    public TxPrimitive<Integer> HighestManagementScore;
    public String ManagementLevel;
    public String ExecutiveType;
    public TxPrimitive<Integer> MinimumYears;
    public TxPrimitive<Integer> MaximumYears;
    public TxPrimitive<Integer> MinimumYearsManagement;
    public TxPrimitive<Integer> MaximumYearsManagement;
    public String RequiredDegree;
    public TxPrimitive<LocalDate> StartDate;
    public TxPrimitive<LocalDate> EndDate;
    public String JobDescription;
    public String JobRequirements;
    public String Benefits;
    public String EmployerDescription;
    public JobTitles JobTitles;
    public EmployerNames EmployerNames;
    public List<JobDegree> Degrees;
    public List<String> SchoolNames;
    public List<String> CertificationsAndLicenses;
    public List<String> LanguageCodes;
    public Location CurrentLocation;
    public ApplicationDetails ApplicationDetails;
    public PayRange Salary;
    public TxPrimitive<Integer> MinimumWorkingHours;
    public TxPrimitive<Integer> MaximumWorkingHours;
    public String WorkingHours;
    public boolean IsRemote;
    public List<String> DriversLicenses;
    public String EmploymentType;
    public String ContractType;
    public List<String> TermsOfInterest;
    public List<String> Owners;
    @Deprecated
    public List<JobTaxonomyRoot> SkillsData;
    public JobV2Skills Skills;
    public JobMetadata JobMetadata;
    public List<String> UserDefinedTags;

    @Deprecated
    public ParsedJob() {
    }

    public static ParsedJob fromFile(String path) throws IOException, JsonParseException {
        String fileContents = new String(Files.readAllBytes(Paths.get(path, new String[0])), Charset.forName("utf8"));
        return ParsedJob.fromJson(fileContents);
    }

    public static ParsedJob fromJson(String utf8json) throws JsonParseException {
        ParsedJob newJob = TxJsonSerializer.deserialize(utf8json, ParsedJob.class);
        if (newJob.JobMetadata == null) {
            throw new JsonParseException("The provided JSON is not a valid ParsedJob created by the Job Parser");
        }
        return newJob;
    }
}

