/*
 * Decompiled with CFR 0.152.
 */
package com.textkernel.tx.services;

import com.textkernel.tx.EnvironmentSettings;
import com.textkernel.tx.exceptions.TxException;
import com.textkernel.tx.http.HttpResponse;
import com.textkernel.tx.models.GeoCoordinates;
import com.textkernel.tx.models.api.geocoding.Address;
import com.textkernel.tx.models.api.geocoding.GeocodeAndIndexJobRequest;
import com.textkernel.tx.models.api.geocoding.GeocodeAndIndexJobResponse;
import com.textkernel.tx.models.api.geocoding.GeocodeAndIndexJobResponseValue;
import com.textkernel.tx.models.api.geocoding.GeocodeAndIndexResumeRequest;
import com.textkernel.tx.models.api.geocoding.GeocodeAndIndexResumeResponse;
import com.textkernel.tx.models.api.geocoding.GeocodeAndIndexResumeResponseValue;
import com.textkernel.tx.models.api.geocoding.GeocodeCredentials;
import com.textkernel.tx.models.api.geocoding.GeocodeJobRequest;
import com.textkernel.tx.models.api.geocoding.GeocodeJobResponse;
import com.textkernel.tx.models.api.geocoding.GeocodeOptionsBase;
import com.textkernel.tx.models.api.geocoding.GeocodeProvider;
import com.textkernel.tx.models.api.geocoding.GeocodeResumeRequest;
import com.textkernel.tx.models.api.geocoding.GeocodeResumeResponse;
import com.textkernel.tx.models.api.indexes.IndexingOptionsGeneric;
import com.textkernel.tx.models.job.ParsedJob;
import com.textkernel.tx.models.resume.ParsedResume;
import com.textkernel.tx.services.ServiceBase;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class GeocoderService
extends ServiceBase {
    public GeocoderService(OkHttpClient httpClient, EnvironmentSettings settings) {
        super(httpClient, settings);
    }

    private GeocodeResumeResponse internalGeocode(ParsedResume resume, GeocodeCredentials geocodeCredentials, Address address) throws TxException {
        GeocodeResumeRequest request = new GeocodeResumeRequest();
        request.ResumeData = resume;
        request.Provider = geocodeCredentials != null ? geocodeCredentials.Provider : GeocodeProvider.Google;
        request.ProviderKey = geocodeCredentials != null ? geocodeCredentials.ProviderKey : null;
        request.PostalAddress = address;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.geocodeResume()).post(body).build();
        HttpResponse<GeocodeResumeResponse> response = this.executeRequest(apiRequest, GeocodeResumeResponse.class, GeocoderService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    private GeocodeJobResponse internalGeocode(ParsedJob job, GeocodeCredentials geocodeCredentials, Address address) throws TxException {
        GeocodeJobRequest request = new GeocodeJobRequest();
        request.JobData = job;
        request.Provider = geocodeCredentials != null ? geocodeCredentials.Provider : GeocodeProvider.Google;
        request.ProviderKey = geocodeCredentials != null ? geocodeCredentials.ProviderKey : null;
        request.PostalAddress = address;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.geocodeJob()).post(body).build();
        HttpResponse<GeocodeJobResponse> response = this.executeRequest(apiRequest, GeocodeJobResponse.class, GeocoderService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public GeocodeResumeResponse geocode(ParsedResume resume, GeocodeCredentials geocodeCredentials) throws TxException {
        return this.internalGeocode(resume, geocodeCredentials, null);
    }

    public GeocodeResumeResponse geocode(ParsedResume resume, Address address, GeocodeCredentials geocodeCredentials) throws TxException {
        return this.internalGeocode(resume, geocodeCredentials, address);
    }

    public GeocodeJobResponse geocode(ParsedJob job, GeocodeCredentials geocodeCredentials) throws TxException {
        return this.internalGeocode(job, geocodeCredentials, null);
    }

    public GeocodeJobResponse geocode(ParsedJob job, Address address, GeocodeCredentials geocodeCredentials) throws TxException {
        return this.internalGeocode(job, geocodeCredentials, address);
    }

    private GeocodeAndIndexResumeResponse internalGeocodeAndIndex(ParsedResume resume, GeocodeCredentials geocodeCredentials, IndexingOptionsGeneric indexingOptions, boolean indexIfGeocodeFails, Address address, GeoCoordinates coordinates) throws TxException {
        this.setEnvironment(indexingOptions);
        GeocodeOptionsBase options = new GeocodeOptionsBase();
        options.Provider = geocodeCredentials != null ? geocodeCredentials.Provider : GeocodeProvider.Google;
        options.ProviderKey = geocodeCredentials != null ? geocodeCredentials.ProviderKey : null;
        options.PostalAddress = address;
        options.GeoCoordinates = coordinates;
        GeocodeAndIndexResumeRequest request = new GeocodeAndIndexResumeRequest();
        request.ResumeData = resume;
        request.GeocodeOptions = options;
        request.IndexingOptions = indexingOptions;
        request.IndexIfGeocodeFails = indexIfGeocodeFails;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.geocodeAndIndexResume()).post(body).build();
        HttpResponse<GeocodeAndIndexResumeResponse> response = this.executeRequest(apiRequest, GeocodeAndIndexResumeResponse.class, GeocoderService.getBodyIfDebug(apiRequest));
        GeocodeAndIndexResumeResponseValue responseVal = (GeocodeAndIndexResumeResponseValue)response.getData().Value;
        if (!indexIfGeocodeFails && responseVal.GeocodeResponse != null && !responseVal.GeocodeResponse.isSuccess()) {
            throw new TxException(GeocoderService.getBodyIfDebug(apiRequest), response.getResponse(), responseVal.GeocodeResponse, response.getData().getInfo().TransactionId);
        }
        if (responseVal.IndexingResponse != null && !responseVal.IndexingResponse.isSuccess()) {
            throw new TxException(GeocoderService.getBodyIfDebug(apiRequest), response.getResponse(), responseVal.IndexingResponse, response.getData().getInfo().TransactionId);
        }
        return response.getData();
    }

    private GeocodeAndIndexJobResponse internalGeocodeAndIndex(ParsedJob job, GeocodeCredentials geocodeCredentials, IndexingOptionsGeneric indexingOptions, boolean indexIfGeocodeFails, Address address, GeoCoordinates coordinates) throws TxException {
        this.setEnvironment(indexingOptions);
        GeocodeOptionsBase options = new GeocodeOptionsBase();
        options.Provider = geocodeCredentials != null ? geocodeCredentials.Provider : GeocodeProvider.Google;
        options.ProviderKey = geocodeCredentials != null ? geocodeCredentials.ProviderKey : null;
        options.PostalAddress = address;
        options.GeoCoordinates = coordinates;
        GeocodeAndIndexJobRequest request = new GeocodeAndIndexJobRequest();
        request.JobData = job;
        request.GeocodeOptions = options;
        request.IndexingOptions = indexingOptions;
        request.IndexIfGeocodeFails = indexIfGeocodeFails;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.geocodeAndIndexJob()).post(body).build();
        HttpResponse<GeocodeAndIndexJobResponse> response = this.executeRequest(apiRequest, GeocodeAndIndexJobResponse.class, GeocoderService.getBodyIfDebug(apiRequest));
        GeocodeAndIndexJobResponseValue responseVal = (GeocodeAndIndexJobResponseValue)response.getData().Value;
        if (!indexIfGeocodeFails && responseVal.GeocodeResponse != null && !responseVal.GeocodeResponse.isSuccess()) {
            throw new TxException(GeocoderService.getBodyIfDebug(apiRequest), response.getResponse(), responseVal.GeocodeResponse, response.getData().getInfo().TransactionId);
        }
        if (responseVal.IndexingResponse != null && !responseVal.IndexingResponse.isSuccess()) {
            throw new TxException(GeocoderService.getBodyIfDebug(apiRequest), response.getResponse(), responseVal.IndexingResponse, response.getData().getInfo().TransactionId);
        }
        return response.getData();
    }

    public GeocodeAndIndexResumeResponse geocodeAndIndex(ParsedResume resume, IndexingOptionsGeneric indexingOptions, boolean indexIfGeocodeFails, GeocodeCredentials geocodeCredentials) throws TxException {
        return this.internalGeocodeAndIndex(resume, geocodeCredentials, indexingOptions, indexIfGeocodeFails, null, null);
    }

    public GeocodeAndIndexResumeResponse geocodeAndIndex(ParsedResume resume, IndexingOptionsGeneric indexingOptions, Address address, boolean indexIfGeocodeFails, GeocodeCredentials geocodeCredentials) throws TxException {
        return this.internalGeocodeAndIndex(resume, geocodeCredentials, indexingOptions, indexIfGeocodeFails, address, null);
    }

    public GeocodeAndIndexResumeResponse geocodeAndIndex(ParsedResume resume, IndexingOptionsGeneric indexingOptions, GeoCoordinates coordinates, boolean indexIfGeocodeFails, GeocodeCredentials geocodeCredentials) throws TxException {
        return this.internalGeocodeAndIndex(resume, geocodeCredentials, indexingOptions, indexIfGeocodeFails, null, coordinates);
    }

    public GeocodeAndIndexJobResponse geocodeAndIndex(ParsedJob job, IndexingOptionsGeneric indexingOptions, boolean indexIfGeocodeFails, GeocodeCredentials geocodeCredentials) throws TxException {
        return this.internalGeocodeAndIndex(job, geocodeCredentials, indexingOptions, indexIfGeocodeFails, null, null);
    }

    public GeocodeAndIndexJobResponse geocodeAndIndex(ParsedJob job, IndexingOptionsGeneric indexingOptions, Address address, boolean indexIfGeocodeFails, GeocodeCredentials geocodeCredentials) throws TxException {
        return this.internalGeocodeAndIndex(job, geocodeCredentials, indexingOptions, indexIfGeocodeFails, address, null);
    }

    public GeocodeAndIndexJobResponse geocodeAndIndex(ParsedJob job, IndexingOptionsGeneric indexingOptions, GeoCoordinates coordinates, boolean indexIfGeocodeFails, GeocodeCredentials geocodeCredentials) throws TxException {
        return this.internalGeocodeAndIndex(job, geocodeCredentials, indexingOptions, indexIfGeocodeFails, null, coordinates);
    }
}

