/*
 * Decompiled with CFR 0.152.
 */
package com.textkernel.tx.services;

import com.textkernel.tx.EnvironmentSettings;
import com.textkernel.tx.exceptions.TxException;
import com.textkernel.tx.http.HttpResponse;
import com.textkernel.tx.models.api.bimetricscoring.BimetricScoreJobRequest;
import com.textkernel.tx.models.api.bimetricscoring.BimetricScoreResponse;
import com.textkernel.tx.models.api.bimetricscoring.BimetricScoreResumeRequest;
import com.textkernel.tx.models.api.bimetricscoring.IParsedDocWithId;
import com.textkernel.tx.models.api.bimetricscoring.ParsedJobWithId;
import com.textkernel.tx.models.api.bimetricscoring.ParsedResumeWithId;
import com.textkernel.tx.models.api.indexes.CreateIndexRequest;
import com.textkernel.tx.models.api.indexes.CreateIndexResponse;
import com.textkernel.tx.models.api.indexes.DeleteDocumentResponse;
import com.textkernel.tx.models.api.indexes.DeleteIndexResponse;
import com.textkernel.tx.models.api.indexes.DeleteMultipleDocumentsRequest;
import com.textkernel.tx.models.api.indexes.DeleteMultipleDocumentsResponse;
import com.textkernel.tx.models.api.indexes.GetAllIndexesResponse;
import com.textkernel.tx.models.api.indexes.GetJobResponse;
import com.textkernel.tx.models.api.indexes.GetResumeResponse;
import com.textkernel.tx.models.api.indexes.IndexDocumentResponse;
import com.textkernel.tx.models.api.indexes.IndexJobInfo;
import com.textkernel.tx.models.api.indexes.IndexJobRequest;
import com.textkernel.tx.models.api.indexes.IndexMultipleDocumentsResponse;
import com.textkernel.tx.models.api.indexes.IndexMultipleJobsRequest;
import com.textkernel.tx.models.api.indexes.IndexMultipleResumesRequest;
import com.textkernel.tx.models.api.indexes.IndexResumeInfo;
import com.textkernel.tx.models.api.indexes.IndexResumeRequest;
import com.textkernel.tx.models.api.indexes.UpdateUserDefinedTagsRequest;
import com.textkernel.tx.models.api.indexes.UpdateUserDefinedTagsResponse;
import com.textkernel.tx.models.api.indexes.UserDefinedTagsMethod;
import com.textkernel.tx.models.api.matching.CategoryWeights;
import com.textkernel.tx.models.api.matching.MatchJobRequest;
import com.textkernel.tx.models.api.matching.MatchResponse;
import com.textkernel.tx.models.api.matching.MatchResumeRequest;
import com.textkernel.tx.models.api.matching.SearchRequest;
import com.textkernel.tx.models.api.matching.SearchResponse;
import com.textkernel.tx.models.api.matching.request.FilterCriteria;
import com.textkernel.tx.models.api.matching.request.MatchByDocumentIdOptions;
import com.textkernel.tx.models.api.matching.request.PaginationSettings;
import com.textkernel.tx.models.api.matching.request.SearchMatchSettings;
import com.textkernel.tx.models.job.ParsedJob;
import com.textkernel.tx.models.matching.IndexType;
import com.textkernel.tx.models.resume.ParsedResume;
import com.textkernel.tx.services.ServiceBase;
import java.util.List;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class SearchMatchService
extends ServiceBase {
    public SearchMatchService(OkHttpClient httpClient, EnvironmentSettings settings) {
        super(httpClient, settings);
    }

    public CreateIndexResponse createIndex(IndexType type, String indexId) throws TxException {
        CreateIndexRequest request = new CreateIndexRequest();
        request.IndexType = type;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.index(indexId)).post(body).build();
        HttpResponse<CreateIndexResponse> response = this.executeRequest(apiRequest, CreateIndexResponse.class, SearchMatchService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public GetAllIndexesResponse getAllIndexes() throws TxException {
        Request apiRequest = new Request.Builder().url(this._endpoints.allIndexes()).build();
        HttpResponse<GetAllIndexesResponse> response = this.executeRequest(apiRequest, GetAllIndexesResponse.class, SearchMatchService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public DeleteIndexResponse deleteIndex(String indexId) throws TxException {
        Request apiRequest = new Request.Builder().url(this._endpoints.index(indexId)).delete().build();
        HttpResponse<DeleteIndexResponse> response = this.executeRequest(apiRequest, DeleteIndexResponse.class, SearchMatchService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public IndexDocumentResponse indexDocument(ParsedResume resume, String indexId, String documentId, List<String> userDefinedTags) throws TxException {
        IndexResumeRequest request = new IndexResumeRequest();
        request.ResumeData = resume;
        request.UserDefinedTags = userDefinedTags;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.resume(indexId, documentId)).post(body).build();
        HttpResponse<IndexDocumentResponse> response = this.executeRequest(apiRequest, IndexDocumentResponse.class, SearchMatchService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public IndexDocumentResponse indexDocument(ParsedJob job, String indexId, String documentId, List<String> userDefinedTags) throws TxException {
        IndexJobRequest request = new IndexJobRequest();
        request.JobData = job;
        request.UserDefinedTags = userDefinedTags;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.job(indexId, documentId)).post(body).build();
        HttpResponse<IndexDocumentResponse> response = this.executeRequest(apiRequest, IndexDocumentResponse.class, SearchMatchService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public IndexMultipleDocumentsResponse indexMultipleResumes(List<IndexResumeInfo> resumes, String indexId) throws TxException {
        IndexMultipleResumesRequest request = new IndexMultipleResumesRequest();
        request.Resumes = resumes;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.multipleResumes(indexId)).post(body).build();
        HttpResponse<IndexMultipleDocumentsResponse> response = this.executeRequest(apiRequest, IndexMultipleDocumentsResponse.class, SearchMatchService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public IndexMultipleDocumentsResponse indexMultipleJobs(List<IndexJobInfo> jobs, String indexId) throws TxException {
        IndexMultipleJobsRequest request = new IndexMultipleJobsRequest();
        request.Jobs = jobs;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.multipleJobs(indexId)).post(body).build();
        HttpResponse<IndexMultipleDocumentsResponse> response = this.executeRequest(apiRequest, IndexMultipleDocumentsResponse.class, SearchMatchService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public DeleteDocumentResponse deleteDocument(String indexId, String documentId) throws TxException {
        Request apiRequest = new Request.Builder().url(this._endpoints.document(indexId, documentId)).delete().build();
        HttpResponse<DeleteDocumentResponse> response = this.executeRequest(apiRequest, DeleteDocumentResponse.class, SearchMatchService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public DeleteMultipleDocumentsResponse deleteMultipleDocuments(String indexId, List<String> documentIds) throws TxException {
        DeleteMultipleDocumentsRequest request = new DeleteMultipleDocumentsRequest();
        request.DocumentIds = documentIds;
        RequestBody requestBody = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.multipleDocuments(indexId)).delete(requestBody).build();
        HttpResponse<DeleteMultipleDocumentsResponse> response = this.executeRequest(apiRequest, DeleteMultipleDocumentsResponse.class, SearchMatchService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public GetResumeResponse getResume(String indexId, String documentId) throws TxException {
        Request apiRequest = new Request.Builder().url(this._endpoints.resume(indexId, documentId)).build();
        HttpResponse<GetResumeResponse> response = this.executeRequest(apiRequest, GetResumeResponse.class, SearchMatchService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public GetJobResponse getJob(String indexId, String documentId) throws TxException {
        Request apiRequest = new Request.Builder().url(this._endpoints.job(indexId, documentId)).build();
        HttpResponse<GetJobResponse> response = this.executeRequest(apiRequest, GetJobResponse.class, SearchMatchService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public UpdateUserDefinedTagsResponse updateResumeUserDefinedTags(String indexId, String documentId, List<String> userDefinedTags, UserDefinedTagsMethod method) throws TxException {
        UpdateUserDefinedTagsRequest request = new UpdateUserDefinedTagsRequest();
        request.UserDefinedTags = userDefinedTags;
        request.Method = method;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.resume(indexId, documentId)).patch(body).build();
        HttpResponse<UpdateUserDefinedTagsResponse> response = this.executeRequest(apiRequest, UpdateUserDefinedTagsResponse.class, SearchMatchService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public UpdateUserDefinedTagsResponse updateJobUserDefinedTags(String indexId, String documentId, List<String> userDefinedTags, UserDefinedTagsMethod method) throws TxException {
        UpdateUserDefinedTagsRequest request = new UpdateUserDefinedTagsRequest();
        request.UserDefinedTags = userDefinedTags;
        request.Method = method;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.job(indexId, documentId)).patch(body).build();
        HttpResponse<UpdateUserDefinedTagsResponse> response = this.executeRequest(apiRequest, UpdateUserDefinedTagsResponse.class, SearchMatchService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public MatchResponse match(ParsedResume resume, List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) throws TxException {
        MatchResumeRequest request = this.createRequest(resume, indexesToQuery, preferredWeights, filters, settings, numResults);
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.matchResume()).post(body).build();
        HttpResponse<MatchResponse> response = this.executeRequest(apiRequest, MatchResponse.class, SearchMatchService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    MatchResumeRequest createRequest(ParsedResume resume, List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) {
        MatchResumeRequest request = new MatchResumeRequest();
        request.ResumeData = resume;
        request.IndexIdsToSearchInto = indexesToQuery;
        request.PreferredCategoryWeights = preferredWeights;
        request.FilterCriteria = filters;
        request.Settings = settings;
        request.Take = numResults;
        return request;
    }

    public MatchResponse match(ParsedJob job, List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) throws TxException {
        MatchJobRequest request = this.createRequest(job, indexesToQuery, preferredWeights, filters, settings, numResults);
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.matchJob()).post(body).build();
        HttpResponse<MatchResponse> response = this.executeRequest(apiRequest, MatchResponse.class, SearchMatchService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    MatchJobRequest createRequest(ParsedJob job, List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) {
        MatchJobRequest request = new MatchJobRequest();
        request.JobData = job;
        request.IndexIdsToSearchInto = indexesToQuery;
        request.PreferredCategoryWeights = preferredWeights;
        request.FilterCriteria = filters;
        request.Settings = settings;
        request.Take = numResults;
        return request;
    }

    public MatchResponse match(String indexId, String documentId, List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) throws TxException {
        MatchByDocumentIdOptions request = this.createRequest(indexesToQuery, preferredWeights, filters, settings, numResults);
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.matchDocId(indexId, documentId)).post(body).build();
        HttpResponse<MatchResponse> response = this.executeRequest(apiRequest, MatchResponse.class, SearchMatchService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    MatchByDocumentIdOptions createRequest(List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) {
        MatchByDocumentIdOptions request = new MatchByDocumentIdOptions();
        request.IndexIdsToSearchInto = indexesToQuery;
        request.PreferredCategoryWeights = preferredWeights;
        request.FilterCriteria = filters;
        request.Settings = settings;
        request.Take = numResults;
        return request;
    }

    public SearchResponse search(List<String> indexesToQuery, FilterCriteria query, SearchMatchSettings settings, PaginationSettings pagination) throws TxException {
        SearchRequest request = this.createRequest(indexesToQuery, query, settings, pagination);
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.search()).post(body).build();
        HttpResponse<SearchResponse> response = this.executeRequest(apiRequest, SearchResponse.class, SearchMatchService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    SearchRequest createRequest(List<String> indexesToQuery, FilterCriteria query, SearchMatchSettings settings, PaginationSettings pagination) {
        SearchRequest request = new SearchRequest();
        request.IndexIdsToSearchInto = indexesToQuery;
        request.FilterCriteria = query;
        request.Settings = settings;
        request.PaginationSettings = pagination;
        return request;
    }

    public <TTarget extends IParsedDocWithId> BimetricScoreResponse bimetricScore(ParsedResumeWithId sourceResume, List<TTarget> targetDocuments, CategoryWeights preferredWeights, SearchMatchSettings settings) throws TxException {
        BimetricScoreResumeRequest request = new BimetricScoreResumeRequest();
        request.PreferredCategoryWeights = preferredWeights;
        request.Settings = settings;
        request.SourceResume = sourceResume;
        if (targetDocuments.size() > 0) {
            if (targetDocuments.get(0) instanceof ParsedResumeWithId) {
                request.TargetResumes = targetDocuments;
            } else {
                request.TargetJobs = targetDocuments;
            }
        }
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.bimetricScoreResume()).post(body).build();
        HttpResponse<BimetricScoreResponse> response = this.executeRequest(apiRequest, BimetricScoreResponse.class, SearchMatchService.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public <TTarget extends IParsedDocWithId> BimetricScoreResponse bimetricScore(ParsedJobWithId sourceJob, List<TTarget> targetDocuments, CategoryWeights preferredWeights, SearchMatchSettings settings) throws TxException {
        BimetricScoreJobRequest request = new BimetricScoreJobRequest();
        request.PreferredCategoryWeights = preferredWeights;
        request.Settings = settings;
        request.SourceJob = sourceJob;
        if (targetDocuments.size() > 0) {
            if (targetDocuments.get(0) instanceof ParsedResumeWithId) {
                request.TargetResumes = targetDocuments;
            } else {
                request.TargetJobs = targetDocuments;
            }
        }
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.bimetricScoreJob()).post(body).build();
        HttpResponse<BimetricScoreResponse> response = this.executeRequest(apiRequest, BimetricScoreResponse.class, SearchMatchService.getBodyIfDebug(apiRequest));
        return response.getData();
    }
}

