/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.aop.core;

import com.thankjava.toolkit.aop.anno.After;
import com.thankjava.toolkit.aop.anno.Before;
import com.thankjava.toolkit.aop.cache.Cache;
import com.thankjava.toolkit.aop.entity.AopConfig;
import com.thankjava.toolkit.aop.entity.AopParam;
import com.thankjava.toolkit.reflect.ReflectHelper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class InvokeInterceptor
implements InvocationHandler {
    private Object implementObject;

    public InvokeInterceptor(Object implementObject) {
        this.implementObject = implementObject;
        if (!Cache.isScannedClass(implementObject.getClass())) {
            this.scanneAnno(implementObject);
        }
    }

    private void scanneAnno(Object implementObject) {
        Method[] methods = ReflectHelper.getAllMethod(implementObject);
        if (methods != null) {
            AopConfig config = null;
            Before before = null;
            After after = null;
            for (Method method : methods) {
                Class<?>[] argsType;
                config = new AopConfig();
                for (Class<?> clazz : argsType = method.getParameterTypes()) {
                    config.setArgs(clazz.getName());
                }
                before = method.getAnnotation(Before.class);
                after = method.getAnnotation(After.class);
                config.setMethodName(method.getName());
                config.setClassPath(implementObject.getClass().getName());
                if (before == null && after == null) {
                    config.setUsedAop(false);
                } else {
                    config.setProxyInstance(implementObject);
                    config.setUsedAop(true);
                    if (before != null) {
                        config.setBefore(before);
                        try {
                            config.setAopBeforeInstance(before.cutClass().newInstance());
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                    if (after != null) {
                        config.setAfter(after);
                        try {
                            config.setAopAfterInstance(before.cutClass().newInstance());
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                }
                Cache.put(config);
            }
        }
    }

    private String getAopConfgKey(Method method) {
        Class<?>[] argsType;
        StringBuffer sb = new StringBuffer();
        sb.append(this.implementObject.getClass().getName());
        sb.append(method.getName());
        for (Class<?> clazz : argsType = method.getParameterTypes()) {
            sb.append(clazz.getName());
        }
        return sb.toString();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        AopConfig aopConfig = Cache.getAop(this.getAopConfgKey(method));
        if (!aopConfig.isUsedAop()) {
            return method.invoke(this.implementObject, args);
        }
        Before before = aopConfig.getBefore();
        Method aopMethod = null;
        Object aopInstance = null;
        AopParam aopParam = null;
        if (before != null) {
            aopInstance = aopConfig.getAopBeforeInstance();
            aopMethod = ReflectHelper.getMethod(aopInstance, before.cutMethod(), AopParam.class);
            aopParam = new AopParam(args);
            aopParam.setProxyInstance(aopConfig.getProxyInstance());
            aopParam = (AopParam)ReflectHelper.invokeMethod(aopInstance, aopMethod, aopParam);
        }
        if (aopParam != null && !aopParam.isInvokeProxyMethod()) {
            return aopParam.getResult();
        }
        Object invokeReturn = method.invoke(this.implementObject, args);
        After after = aopConfig.getAfter();
        if (after != null) {
            aopInstance = aopConfig.getAopAfterInstance();
            aopMethod = ReflectHelper.getMethod(aopInstance, after.cutMethod(), AopParam.class);
            if (aopParam == null) {
                aopParam = new AopParam(args);
                aopParam.setProxyInstance(aopConfig.getProxyInstance());
            } else {
                aopParam = new AopParam(aopParam.getParams());
                aopParam.setProxyInstance(aopConfig.getProxyInstance());
            }
            aopParam.setResult(invokeReturn);
            aopParam = (AopParam)ReflectHelper.invokeMethod(aopInstance, aopMethod, aopParam);
            return aopParam.getResult();
        }
        return invokeReturn;
    }
}

