/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class TimeHelper {
    private TimeHelper() {
    }

    public static Date parseDate(String date, TimeType timeType) {
        SimpleDateFormat sdf = TimeHelper.getDateFormat(timeType);
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SimpleDateFormat getDateFormat(TimeType timeType) {
        if (timeType == null) {
            timeType = TimeType.DEFAULT;
        }
        return new SimpleDateFormat(timeType.getType());
    }

    public static String formatDate(TimeType timeType, Date date) {
        return TimeHelper.getDateFormat(timeType).format(date);
    }

    public static Date offsetDate(Date date, int calendarUnit, int dateOffset) {
        if (date == null) {
            return date;
        }
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(calendarUnit, dateOffset);
        return ca.getTime();
    }

    public static enum TimeType {
        DEFAULT("yyyy-MM-dd|HH:mm:ss"),
        yyyyMMddHH("yyyyMMddHH"),
        yyyyMMddHHmmssSSS("yyyyMMddHHmmssSSS"),
        yyyyMMddHHmmss("yyyyMMddHHmmss"),
        yyyyMMdd("yyyyMMdd"),
        HHmmss("HHmmss");

        String type;

        private TimeType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

