/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.httpclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Map;

public final class DefaultHttpClient {
    private static final String CHARSET = "utf-8";
    private static final String USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:43.0) Gecko/20100101 Thankjava/fast-toolkit";

    private DefaultHttpClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url) {
        String result = "";
        BufferedReader in = null;
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection connection = realUrl.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", USER_AGENT);
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, String param, Map<String, String> props, String strStream) {
        BufferedReader in = null;
        String result = "";
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection connection = realUrl.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("content-type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("user-agent", USER_AGENT);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            if (props != null && props.size() > 0) {
                for (Map.Entry<String, String> prop : props.entrySet()) {
                    connection.setRequestProperty(prop.getKey(), prop.getValue());
                }
            }
            if (param != null) {
                OutputStreamWriter osw = new OutputStreamWriter(connection.getOutputStream());
                osw.write(param);
                osw.flush();
                osw.close();
            }
            if (strStream != null) {
                OutputStream outputStream = connection.getOutputStream();
                outputStream.write(strStream.getBytes(CHARSET));
            }
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static String encode(String str) {
        try {
            return URLEncoder.encode(str, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

