/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.reflect;

import com.thankjava.toolkit.reflect.ReflectHelper;
import com.thankjava.toolkit.reflect.copier.ValueCast;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public final class BeanCopier {
    private BeanCopier() {
    }

    public static <OriginObject, TargetObject> TargetObject copy(OriginObject originObject, Class<TargetObject> targetClass) {
        if (originObject == null || targetClass == null) {
            throw new IllegalArgumentException("originaObject and targetClass can't be null");
        }
        TargetObject targetObject = null;
        try {
            targetObject = targetClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new ClassCastException("targetClass can't be instance");
        }
        catch (IllegalAccessException e) {
            throw new ClassCastException("targetClass can't be instance");
        }
        return BeanCopier.setValue(originObject, targetObject, targetClass);
    }

    public static <OriginObject, TargetObject> TargetObject append(OriginObject originObject, TargetObject targetObject) {
        if (originObject == null || targetObject == null) {
            throw new IllegalArgumentException("originaObject and targetObject can't be null");
        }
        Class<?> targetClass = targetObject.getClass();
        return BeanCopier.setValue(originObject, targetObject, targetClass);
    }

    public static <OriginObject, TargetObject> List<TargetObject> copyList(List<OriginObject> originObjects, Class<TargetObject> targetClass) {
        if (originObjects == null || targetClass == null) {
            throw new IllegalArgumentException("originaObject and targetClass can't be null");
        }
        ArrayList<TargetObject> targetObjects = new ArrayList<TargetObject>();
        for (OriginObject originObject : originObjects) {
            targetObjects.add(BeanCopier.copy(originObject, targetClass));
        }
        return targetObjects;
    }

    private static <OriginObject, TargetObject> TargetObject setValue(OriginObject originObject, TargetObject targetObject, Class<TargetObject> targetClass) {
        Field[] targetFields = ReflectHelper.getFieldArrayExcludeUID(targetClass);
        Field originField = null;
        Object originValue = null;
        Object targetValue = null;
        for (Field targetField : targetFields) {
            originField = ReflectHelper.getField(originObject, targetField.getName());
            if (originField == null || Modifier.isStatic(originField.getModifiers())) continue;
            targetField.setAccessible(true);
            originField.setAccessible(true);
            originValue = ReflectHelper.getFieldVal(originObject, targetField.getName());
            if (originValue == null || (targetValue = ValueCast.cast(targetField, targetObject, originValue)) == null) continue;
            try {
                targetField.set(targetObject, targetValue);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("fail to targetObject attribute assignment");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("fail to targetObject attribute assignment");
            }
        }
        return targetObject;
    }
}

