/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ReflectHelper {
    private ReflectHelper() {
    }

    public static Field getField(Object obj, String fieldName) {
        if (obj == null) {
            return null;
        }
        Field field = null;
        for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(fieldName);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return field;
    }

    public static Field[] getFieldArrayIncludeSupClassExcludeUID(Class<?> clazz) {
        Field[] currField = clazz.getDeclaredFields();
        clazz = clazz.getSuperclass();
        Field[] supField = clazz.getDeclaredFields();
        Field[] temp = new Field[currField.length + supField.length];
        int length = 0;
        for (Field curr : currField) {
            if ("serialVersionUID".equals(curr.getName())) continue;
            temp[length] = curr;
            ++length;
        }
        for (Field sup : supField) {
            if ("serialVersionUID".equals(sup.getName())) continue;
            temp[length] = sup;
            ++length;
        }
        Field[] all = new Field[length];
        for (int i = 0; i < all.length; ++i) {
            all[i] = temp[i];
        }
        return all;
    }

    public static Field[] getFieldArrayExcludeUID(Class<?> clazz) {
        Field[] currField = clazz.getDeclaredFields();
        Field[] temp = new Field[currField.length];
        boolean getUid = false;
        int index = 0;
        for (Field curr : currField) {
            if ("serialVersionUID".equals(curr.getName())) {
                getUid = true;
                continue;
            }
            temp[index] = curr;
            ++index;
        }
        if (!getUid) {
            return currField;
        }
        Field[] all = new Field[index];
        for (int i = 0; i < all.length; ++i) {
            all[i] = temp[i];
        }
        return all;
    }

    public static Object getFieldVal(Object obj, String fieldName) {
        if (obj == null) {
            return null;
        }
        try {
            Field field = ReflectHelper.getField(obj, fieldName);
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setFieldVal(Object obj, String fieldName, Object value) {
        if (obj == null) {
            return;
        }
        try {
            Field field = ReflectHelper.getField(obj, fieldName);
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static Method getMethod(Object obj, String methodName, Class<?> ... parameterTypes) {
        if (obj == null) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Method[] getAllMethod(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        try {
            return clazz.getDeclaredMethods();
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object invokeMethod(Object obj, Method method, Object ... parameter) {
        try {
            method.setAccessible(true);
            return method.invoke(obj, parameter);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Class<?> getSignificantSupperClass(Class<?> classType) {
        Class<?> supperClass = classType;
        while (classType != null && Object.class != (classType = classType.getSuperclass()) && null != classType) {
            supperClass = classType;
        }
        return supperClass;
    }
}

