/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.reflect.copier;

import com.thankjava.toolkit.reflect.ReflectHelper;
import com.thankjava.toolkit.reflect.copier.ClassType;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;

class TypeSort {
    TypeSort() {
    }

    private static boolean isBaseJDKSimpleType(Class<?> type) {
        if (String.class == type) {
            return true;
        }
        if (Integer.class == type || Integer.TYPE == type) {
            return true;
        }
        if (Long.class == type || Long.TYPE == type) {
            return true;
        }
        if (Double.class == type || Double.TYPE == type) {
            return true;
        }
        if (Boolean.class == type || Boolean.TYPE == type) {
            return true;
        }
        if (Float.class == type || Float.TYPE == type) {
            return true;
        }
        if (Character.class == type || Character.TYPE == type) {
            return true;
        }
        return Byte.class == type || Byte.TYPE == type;
    }

    private static boolean isBaseJDKMapType(Class<?> type) {
        return Map.class == type || AbstractMap.class == type;
    }

    private static boolean isBaseJDKListType(Class<?> type) {
        return List.class == type || AbstractCollection.class == type;
    }

    static ClassType sortType(Class<?> type) {
        if (TypeSort.isBaseJDKSimpleType(type)) {
            return ClassType.JDK_BASE;
        }
        if (type.isArray()) {
            return ClassType.JDK_ARRAY;
        }
        if (type.isEnum()) {
            return ClassType.JDK_ENUM;
        }
        if (TypeSort.isBaseJDKListType(type = ReflectHelper.getSignificantSupperClass(type))) {
            return ClassType.JDK_LIST;
        }
        if (TypeSort.isBaseJDKMapType(type)) {
            return ClassType.JDK_MAP;
        }
        return ClassType.T;
    }
}

