/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.reflect.copier;

import com.thankjava.toolkit.reflect.BeanCopier;
import com.thankjava.toolkit.reflect.copier.TypeSort;
import com.thankjava.toolkit.reflect.copier.ValueFactory;
import java.lang.reflect.Field;

public class ValueCast {
    public static Object cast(Field targetField, Object targetObject, Object originValue) {
        return ValueCast.createValueCore(targetField, targetField.getType(), targetObject, originValue);
    }

    static Object createValueCore(Field targetField, Class<?> targetFieldType, Object targetObject, Object originValue) {
        switch (TypeSort.sortType(targetFieldType)) {
            case JDK_BASE: {
                return originValue;
            }
            case JDK_ARRAY: {
                return ValueFactory.createValueArray(targetField, targetFieldType, targetObject, originValue);
            }
            case JDK_ENUM: {
                return ValueFactory.createValueEnum(targetField, targetFieldType, targetObject, originValue);
            }
            case JDK_LIST: {
                return ValueFactory.createValueList(targetField, targetFieldType, targetObject, originValue);
            }
            case JDK_MAP: {
                return ValueFactory.createValueMap(targetField, targetFieldType, targetObject, originValue);
            }
        }
        return BeanCopier.copy(originValue, targetFieldType);
    }
}

