/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.reflect.copier;

import com.thankjava.toolkit.reflect.ReflectHelper;
import com.thankjava.toolkit.reflect.copier.ValueCast;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class ValueFactory {
    ValueFactory() {
    }

    static Object createValueArray(Field targetField, Class<?> targetFieldType, Object targetObject, Object originValue) {
        if (originValue == null) {
            return null;
        }
        Class<?> proxyType = targetFieldType.getComponentType();
        Object[] originArray = (Object[])originValue;
        if (originArray.length == 0) {
            return null;
        }
        Object[] targetArray = (Object[])Array.newInstance(proxyType, originArray.length);
        for (int i = 0; i < originArray.length; ++i) {
            targetArray[i] = ValueCast.createValueCore(targetField, proxyType, targetObject, originArray[i]);
        }
        return targetArray;
    }

    static Object createValueEnum(Field targetField, Class<?> targetFieldType, Object targetObject, Object originValue) {
        if (originValue == null) {
            return null;
        }
        Object enumNameObj = ReflectHelper.getFieldVal(originValue, "name");
        if (enumNameObj == null) {
            return null;
        }
        String enumName = (String)enumNameObj;
        return Enum.valueOf(targetFieldType, enumName);
    }

    static Object createValueList(Field targetField, Class<?> targetFieldType, Object targetObject, Object originValue) {
        if (originValue == null) {
            return null;
        }
        List originList = (List)originValue;
        if (originList.size() == 0) {
            return null;
        }
        Class<?> proxyType = originList.get(0).getClass();
        ArrayList<Object> targetList = new ArrayList<Object>();
        for (Object object : originList) {
            targetList.add(ValueCast.createValueCore(targetField, proxyType, targetList, object));
        }
        return targetList;
    }

    static Object createValueMap(Field targetField, Class<?> targetFieldType, Object targetObject, Object originValue) {
        if (originValue == null) {
            return null;
        }
        Map originMap = (Map)originValue;
        if (originMap.size() == 0) {
            return null;
        }
        Class<?> keyClass = null;
        Class<?> valueClass = null;
        Iterator i$ = originMap.entrySet().iterator();
        if (i$.hasNext()) {
            Map.Entry entry = i$.next();
            keyClass = entry.getKey().getClass();
            valueClass = entry.getValue().getClass();
        }
        HashMap<Object, Object> targetMap = new HashMap<Object, Object>();
        for (Map.Entry entry : originMap.entrySet()) {
            targetMap.put(ValueCast.createValueCore(targetField, keyClass, targetObject, entry.getKey()), ValueCast.createValueCore(targetField, valueClass, targetObject, entry.getValue()));
        }
        return targetMap;
    }
}

