/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.security;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public final class RSASecurity {
    private static final String algorithm = "RSA";
    private static final String original = "SHA1WithRSA";
    private static final String charset = "utf-8";

    public static Key[] keyGen(int keysize) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance(algorithm);
        generator.initialize(keysize);
        KeyPair keyPair = generator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        Key[] keys = new Key[]{publicKey, privateKey};
        return keys;
    }

    public static byte[] encrypt(String originalText, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, UnsupportedEncodingException {
        Signature signature = Signature.getInstance(original);
        signature.initSign(privateKey);
        signature.update(originalText.getBytes(charset));
        return signature.sign();
    }

    public static boolean verify(String originalText, byte[] ciphertext, PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, UnsupportedEncodingException {
        Signature signature = Signature.getInstance(original);
        signature.initVerify(publicKey);
        signature.update(originalText.getBytes(charset));
        return signature.verify(ciphertext);
    }
}

