/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.thread;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ThreadPool {
    private static final int INIT_THREAD_NUM = 50;
    private static final int MAX_THREAD_NUM = 10000;
    private static final int ALIVE_TIME = 1000;
    private static final int WAIT_RUNABLE_MAX_NUM = 200;
    private static ThreadPoolExecutor threadPoolExecutor;

    public ThreadPool() {
        threadPoolExecutor = new ThreadPoolExecutor(50, 10000, 1000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(200), new ThreadPoolExecutor.DiscardOldestPolicy());
        threadPoolExecutor.allowCoreThreadTimeOut(true);
    }

    public ThreadPool(int initThreadNum, int maxThreadNum, int aliveTime, int waitRunableMaxNum) {
        threadPoolExecutor = new ThreadPoolExecutor(initThreadNum, maxThreadNum, (long)aliveTime, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(waitRunableMaxNum), new ThreadPoolExecutor.DiscardOldestPolicy());
        threadPoolExecutor.allowCoreThreadTimeOut(true);
    }

    public void execute(Runnable command) {
        threadPoolExecutor.execute(command);
    }

    public void destroy() {
        if (!threadPoolExecutor.isShutdown()) {
            threadPoolExecutor.shutdown();
        }
    }
}

