/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.thread;

import com.thankjava.toolkit.vo.thread.TaskEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class ThreadTask {
    private ScheduledExecutorService scheduledExecutorService;
    private ConcurrentHashMap<String, ScheduledFuture<?>> runningTask = new ConcurrentHashMap();

    public ThreadTask(int poolSize) {
        this.scheduledExecutorService = Executors.newScheduledThreadPool(poolSize);
    }

    public void addTaskAtFixedRate(TaskEntity taskEntity) {
        ScheduledFuture<?> future = this.scheduledExecutorService.scheduleAtFixedRate(taskEntity.getRunnable(), taskEntity.getStartDelayTime(), taskEntity.getTimeInterval(), TimeUnit.SECONDS);
        this.runningTask.put(taskEntity.getTaskId(), future);
    }

    public void addTaskAtFixedRate(List<TaskEntity> taskEntitys) {
        for (TaskEntity taskEntity : taskEntitys) {
            ScheduledFuture<?> future = this.scheduledExecutorService.scheduleAtFixedRate(taskEntity.getRunnable(), taskEntity.getStartDelayTime(), taskEntity.getTimeInterval(), TimeUnit.SECONDS);
            this.runningTask.put(taskEntity.getTaskId(), future);
        }
    }

    public void addTaskWithFixedDelay(TaskEntity taskEntity) {
        ScheduledFuture<?> future = this.scheduledExecutorService.scheduleWithFixedDelay(taskEntity.getRunnable(), taskEntity.getStartDelayTime(), taskEntity.getTimeInterval(), TimeUnit.SECONDS);
        this.runningTask.put(taskEntity.getTaskId(), future);
    }

    public void addTaskWithFixedDelay(List<TaskEntity> taskEntitys) {
        for (TaskEntity taskEntity : taskEntitys) {
            ScheduledFuture<?> future = this.scheduledExecutorService.scheduleWithFixedDelay(taskEntity.getRunnable(), taskEntity.getStartDelayTime(), taskEntity.getTimeInterval(), TimeUnit.SECONDS);
            this.runningTask.put(taskEntity.getTaskId(), future);
        }
    }

    public void addTaskRunOnce(int startDelayTime, Runnable runnable) {
        this.scheduledExecutorService.schedule(runnable, (long)startDelayTime, TimeUnit.SECONDS);
    }

    public boolean removeTaskByTaskId(String taskId, boolean isInterrupt) {
        ScheduledFuture<?> future = this.runningTask.get(taskId);
        boolean flag = future.cancel(isInterrupt);
        if (flag) {
            this.runningTask.remove(taskId);
        }
        return flag;
    }

    public int getRunningTaskCount() {
        return this.runningTask.size();
    }

    public void clearAllTasks(boolean isInterrupt) {
        ArrayList<String> taskIds = new ArrayList<String>();
        for (Map.Entry<String, ScheduledFuture<?>> tasks : this.runningTask.entrySet()) {
            ScheduledFuture<?> future = this.runningTask.get(tasks.getKey());
            boolean flag = future.cancel(isInterrupt);
            if (!flag) continue;
            taskIds.add(tasks.getKey());
        }
        for (String taskId : taskIds) {
            this.runningTask.remove(taskId);
        }
    }

    public void shutdown() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
    }
}

