/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.core.aop;

import com.thankjava.toolkit.bean.aop.entity.AopArgs;
import com.thankjava.toolkit.bean.aop.entity.AopCache;
import com.thankjava.toolkit.bean.aop.entity.AopConfig;
import com.thankjava.toolkit.core.aop.util.AopScanner;
import com.thankjava.toolkit.core.aop.util.BreakMethod;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

class InvokeInterceptor
implements InvocationHandler {
    private Object implementObject;

    public InvokeInterceptor(Object implementObject) {
        this.implementObject = implementObject;
        AopScanner.scanner(implementObject.getClass(), new Class[0]);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        AopConfig aopConfig = AopCache.getAopConfig(this.implementObject, method);
        if (aopConfig == null) {
            return method.invoke(this.implementObject, args);
        }
        if (!aopConfig.isUsedAop()) {
            return method.invoke(this.implementObject, args);
        }
        AopArgs aopArgs = new AopArgs(args);
        aopArgs.setProxyInstance(proxy);
        BreakMethod.invokeBeforeCutPoint(aopConfig, aopArgs);
        Object invokeReturn = aopArgs.getReturnResult();
        if (aopArgs.isInvokeProxyMethod()) {
            invokeReturn = method.invoke(this.implementObject, aopArgs.getInvokeArgs());
        }
        aopArgs.setReturnResult(invokeReturn);
        BreakMethod.invokeAfterCutPoint(aopConfig, aopArgs);
        return aopArgs.getReturnResult();
    }
}

