/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.core.reflect;

import com.thankjava.toolkit.core.reflect.ReflectUtil;
import com.thankjava.toolkit.core.reflect.copier.ValueCast;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public final class BeanCopierUtil {
    private BeanCopierUtil() {
    }

    public static <OriginObject, TargetObject> TargetObject copy(OriginObject originObject, Class<TargetObject> targetClass) {
        if (originObject == null) {
            return null;
        }
        if (targetClass == null) {
            throw new IllegalArgumentException("targetClass can't be null");
        }
        TargetObject targetObject = null;
        try {
            targetObject = targetClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return BeanCopierUtil.setValue(originObject, targetObject, targetClass);
    }

    public static <OriginObject, TargetObject> void append(OriginObject originObject, TargetObject targetObject) {
        if (originObject == null) {
            return;
        }
        if (targetObject == null) {
            throw new IllegalArgumentException("targetClass can't be null");
        }
        Class<?> targetClass = targetObject.getClass();
        BeanCopierUtil.setValue(originObject, targetObject, targetClass);
    }

    public static <OriginObject, TargetObject> List<TargetObject> copyList(List<OriginObject> originObjects, Class<TargetObject> targetClass) {
        if (originObjects == null) {
            return null;
        }
        if (targetClass == null) {
            throw new IllegalArgumentException("targetClass can't be null");
        }
        ArrayList<TargetObject> targetObjects = new ArrayList<TargetObject>();
        for (OriginObject originObject : originObjects) {
            targetObjects.add(BeanCopierUtil.copy(originObject, targetClass));
        }
        return targetObjects;
    }

    private static <OriginObject, TargetObject> TargetObject setValue(OriginObject originObject, TargetObject targetObject, Class<TargetObject> targetClass) {
        Field[] targetFields = ReflectUtil.getFieldArrayIncludeSupClassExcludeUID(targetClass);
        Field originField = null;
        Object originValue = null;
        Object targetValue = null;
        for (Field targetField : targetFields) {
            originField = ReflectUtil.getField(originObject.getClass(), targetField.getName());
            if (originField == null || Modifier.isStatic(originField.getModifiers())) continue;
            targetField.setAccessible(true);
            originField.setAccessible(true);
            originValue = ReflectUtil.getFieldVal(originObject, targetField.getName());
            if (originValue == null || (targetValue = ValueCast.cast(targetField, targetObject, originValue)) == null) continue;
            try {
                targetField.set(targetObject, targetValue);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return targetObject;
    }
}

