/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.core.bytecode;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

final class ByteCodeJavaFileManager
extends ForwardingJavaFileManager {
    private Map<String, byte[]> byteCodes = new HashMap<String, byte[]>();
    private URI javaSourceURI;
    private String sourceCode;
    private static final String CLASS_URI_PREFIX = "mfm:///";
    private static final String SP = "/";
    private static final String PACKAGE_REG = "package\\s+(\\w+(.\\w+)*)\\s*;";
    private static final String CLASS_NAME_REG = "[class|enum]\\s+(\\w+)\\s*\\{";
    private static final String JAVA_SOURCE_SUFFIX = ".java";

    protected ByteCodeJavaFileManager(String sourceCode, JavaFileManager fileManager) {
        super(fileManager);
        this.sourceCode = sourceCode;
        String javaName = this.resolveJavaName(sourceCode);
        this.javaSourceURI = this.createJavaURI(javaName);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
        return new JavaClassFileObject(className);
    }

    public Map<String, byte[]> getByteCodes() {
        return this.byteCodes;
    }

    URI createJavaURI(String javaName) {
        StringBuffer uri = new StringBuffer(CLASS_URI_PREFIX);
        uri.append(javaName.replace(".", SP));
        uri.append(JAVA_SOURCE_SUFFIX);
        return URI.create(uri.toString());
    }

    String resolveJavaName(String sourceCode) {
        StringBuffer uri = new StringBuffer();
        Pattern pattern = Pattern.compile(PACKAGE_REG);
        Matcher matcher = pattern.matcher(sourceCode);
        boolean includePackage = false;
        if (matcher.find()) {
            includePackage = true;
            uri.append(matcher.group(1));
        }
        if ((matcher = (pattern = Pattern.compile(CLASS_NAME_REG)).matcher(sourceCode)).find()) {
            if (includePackage) {
                uri.append(".");
            }
            uri.append(matcher.group(1));
        }
        return uri.toString();
    }

    class JavaClassFileObject
    extends SimpleJavaFileObject {
        private String className;

        protected JavaClassFileObject(String className) {
            super(URI.create(className), JavaFileObject.Kind.CLASS);
            this.className = className;
        }

        @Override
        public OutputStream openOutputStream() {
            return new FilterOutputStream(new ByteArrayOutputStream()){

                @Override
                public void close() throws IOException {
                    ByteArrayOutputStream bos = (ByteArrayOutputStream)this.out;
                    ByteCodeJavaFileManager.this.byteCodes.put(JavaClassFileObject.this.className, bos.toByteArray());
                    bos.close();
                    this.out.close();
                }
            };
        }
    }

    public class JavaSourceFileObject
    extends SimpleJavaFileObject {
        protected JavaSourceFileObject() {
            super(ByteCodeJavaFileManager.this.javaSourceURI, JavaFileObject.Kind.SOURCE);
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return CharBuffer.wrap(ByteCodeJavaFileManager.this.sourceCode);
        }
    }
}

