/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.core.encrypit;

import com.thankjava.toolkit.bean.encrypit.RSAEncryptAlgorithm;
import com.thankjava.toolkit.bean.encrypit.RSAKey;
import com.thankjava.toolkit.bean.encrypit.RSASignAlgorithm;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public final class RSA {
    private static final String ALGORITHM = "RSA";

    public static RSAKey keyGen(int keySize) {
        KeyPairGenerator generator = null;
        try {
            generator = KeyPairGenerator.getInstance(ALGORITHM);
            generator.initialize(keySize);
            KeyPair keyPair = generator.generateKeyPair();
            return new RSAKey(keyPair.getPublic(), keyPair.getPrivate());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] sign(byte[] contentByteArray, PrivateKey privateKey, RSASignAlgorithm rsaSignAlgorithm) {
        try {
            Signature signature = Signature.getInstance(rsaSignAlgorithm.name());
            signature.initSign(privateKey);
            signature.update(contentByteArray);
            return signature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean verify(byte[] contentByteArray, byte[] cipherByteArray, PublicKey publicKey, RSASignAlgorithm rsaSignAlgorithm) {
        Signature signature = null;
        try {
            signature = Signature.getInstance(rsaSignAlgorithm.name());
            signature.initVerify(publicKey);
            signature.update(contentByteArray);
            return signature.verify(cipherByteArray);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static byte[] encrypt(byte[] contentByteArray, PublicKey publicKey, RSAEncryptAlgorithm rsaEncryptAlgorithm) {
        try {
            Cipher cipher = Cipher.getInstance(rsaEncryptAlgorithm.algorithm);
            cipher.init(1, publicKey);
            return cipher.doFinal(contentByteArray);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decrypt(byte[] cipherByteArray, PrivateKey privateKey, RSAEncryptAlgorithm rsaEncryptAlgorithm) {
        try {
            Cipher cipher = Cipher.getInstance(rsaEncryptAlgorithm.algorithm);
            cipher.init(2, privateKey);
            return cipher.doFinal(cipherByteArray);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

