/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.core.http;

import com.thankjava.toolkit.bean.common.Charset;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;

public final class JDKHttp {
    private static final String CHARSET = Charset.utf8.charset;
    private String httpUrl;
    private String postBodyString;
    private byte[] postBodyByteArray;
    private String requestCharset;
    private String responseCharset = CHARSET;
    private Map<String, String> headers;

    public JDKHttp(String httpUrl) {
        this.httpUrl = httpUrl;
    }

    private static InputStream execute(HttpURLConnection urlConnection) {
        try {
            urlConnection.connect();
            return urlConnection.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String urlEncode(String string, Charset ... charset) {
        try {
            return URLEncoder.encode(string, charset != null && charset.length > 0 ? charset[0].charset : CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public JDKHttp setPostBody(String bodyString, Charset ... charset) {
        this.postBodyString = bodyString;
        this.requestCharset = charset == null || charset.length == 0 ? CHARSET : charset[0].charset;
        return this;
    }

    public JDKHttp setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public JDKHttp setResponseCharset(Charset charset) {
        this.responseCharset = charset != null ? charset.charset : CHARSET;
        return this;
    }

    public JDKHttp setPostBody(byte[] bodyByteArray) {
        this.postBodyByteArray = bodyByteArray;
        return this;
    }

    private URL getUrl() {
        try {
            return new URL(this.httpUrl);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setHttpHeaders(HttpURLConnection urlConnection) {
        if (this.headers != null && this.headers.size() > 0) {
            for (Map.Entry<String, String> h : this.headers.entrySet()) {
                urlConnection.setRequestProperty(h.getKey(), h.getValue());
            }
        }
    }

    private HttpURLConnection getConnection() {
        URL url = this.getUrl();
        if (url == null) {
            return null;
        }
        try {
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            this.setHttpHeaders(urlConnection);
            return urlConnection;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getResponseString(InputStream inputStream) {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, this.responseCharset));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            return stringBuilder.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private byte[] getResponseByteArray(InputStream inputStream) {
        try {
            byte[] array = new byte[inputStream.available()];
            inputStream.read(array);
            return array;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setPostData(HttpURLConnection urlConnection) {
        urlConnection.setDoInput(true);
        urlConnection.setDoOutput(true);
        try {
            urlConnection.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        try {
            if (this.postBodyString != null) {
                OutputStreamWriter outputStream = new OutputStreamWriter(urlConnection.getOutputStream(), this.requestCharset);
                outputStream.write(this.postBodyString);
                outputStream.flush();
                outputStream.close();
            } else if (this.postBodyByteArray != null && this.postBodyByteArray.length > 0) {
                OutputStream outputStream = urlConnection.getOutputStream();
                outputStream.write(this.postBodyByteArray);
                outputStream.flush();
                outputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String doGetResponseString() {
        HttpURLConnection urlConnection = this.getConnection();
        if (urlConnection == null) {
            return null;
        }
        try {
            urlConnection.setRequestMethod("GET");
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        if (urlConnection == null) {
            return null;
        }
        InputStream inputStream = JDKHttp.execute(urlConnection);
        if (inputStream == null) {
            return null;
        }
        return this.getResponseString(inputStream);
    }

    public byte[] doGetResponseByteArray() {
        HttpURLConnection urlConnection = this.getConnection();
        try {
            urlConnection.setRequestMethod("GET");
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        if (urlConnection == null) {
            return null;
        }
        InputStream inputStream = JDKHttp.execute(urlConnection);
        if (inputStream == null) {
            return null;
        }
        return this.getResponseByteArray(inputStream);
    }

    public String doPostResponseString() {
        HttpURLConnection urlConnection = this.getConnection();
        if (urlConnection == null) {
            return null;
        }
        this.setPostData(urlConnection);
        InputStream inputStream = JDKHttp.execute(urlConnection);
        if (inputStream == null) {
            return null;
        }
        return this.getResponseString(inputStream);
    }

    public byte[] doPostResponseByteArray() {
        HttpURLConnection urlConnection = this.getConnection();
        if (urlConnection == null) {
            return null;
        }
        this.setPostData(urlConnection);
        InputStream inputStream = JDKHttp.execute(urlConnection);
        if (inputStream == null) {
            return null;
        }
        return this.getResponseByteArray(inputStream);
    }
}

