/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.core.io.util;

import com.thankjava.toolkit.bean.common.Charset;
import com.thankjava.toolkit.core.io.FileAppendWriter;

public class WriteCSVUtil {
    private FileAppendWriter fileAppendWriter;
    private String lineSeparator;
    StringBuffer stringBuffer = new StringBuffer();

    public WriteCSVUtil(String filePath, Charset charset, LineSeparator lineSeparator) {
        this.fileAppendWriter = new FileAppendWriter(filePath, charset);
        this.lineSeparator = lineSeparator != null ? lineSeparator.separator : System.getProperty("line.separator");
    }

    public void write(String[] dataLine, char dataSeparator) {
        if (dataLine == null || dataLine.length == 0) {
            return;
        }
        this.stringBuffer.setLength(0);
        for (String line : dataLine) {
            this.stringBuffer.append(line);
            this.stringBuffer.append(dataSeparator);
        }
        this.stringBuffer.append(this.lineSeparator);
        this.stringBuffer.deleteCharAt(this.stringBuffer.length() - 2);
        this.fileAppendWriter.write(this.stringBuffer.toString());
    }

    public void write(String line) {
        this.fileAppendWriter.write(line + this.lineSeparator);
    }

    public void close() {
        this.fileAppendWriter.close();
    }

    public static enum LineSeparator {
        CR_MAC("\r"),
        CRLF_WINDOWS("\r\n"),
        LF_UNIX("\n");

        public String separator;

        private LineSeparator(String separator) {
            this.separator = separator;
        }
    }
}

