/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.core.reflect;

import com.thankjava.toolkit.bean.reflect.copier.OriginFieldsCache;
import com.thankjava.toolkit.core.reflect.ReflectUtil;
import com.thankjava.toolkit.core.reflect.copier.ValueCast;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class BeanCopierUtil {
    private static final Map<Class<?>, Field[]> targetFieldsCache = new HashMap();
    private static final Map<Class<?>, OriginFieldsCache> originFieldsCache = new HashMap();

    private BeanCopierUtil() {
    }

    public static <OriginObject, TargetObject> TargetObject copy(OriginObject originObject, Class<TargetObject> targetClass) {
        if (originObject == null) {
            return null;
        }
        if (targetClass == null) {
            throw new IllegalArgumentException("targetClass can't be null");
        }
        TargetObject targetObject = null;
        try {
            targetObject = targetClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return BeanCopierUtil.setValue(originObject, targetObject, targetClass);
    }

    public static <OriginObject, TargetObject> void copy(TargetObject newObject, OriginObject originObject) {
        if (originObject == null) {
            return;
        }
        if (newObject == null) {
            throw new IllegalArgumentException("targetClass can't be null");
        }
        Class<?> targetClass = newObject.getClass();
        BeanCopierUtil.setValue(originObject, newObject, targetClass);
    }

    public static <OriginObject, TargetObject> List<TargetObject> copyList(List<OriginObject> originObjects, Class<TargetObject> targetClass) {
        if (originObjects == null) {
            return null;
        }
        if (targetClass == null) {
            throw new IllegalArgumentException("targetClass can't be null");
        }
        ArrayList<TargetObject> targetObjects = new ArrayList<TargetObject>();
        for (OriginObject originObject : originObjects) {
            targetObjects.add(BeanCopierUtil.copy(originObject, targetClass));
        }
        return targetObjects;
    }

    private static <OriginObject, TargetObject> TargetObject setValue(OriginObject originObject, TargetObject targetObject, Class<TargetObject> targetClass) {
        if (originObject == null) {
            return null;
        }
        Field[] targetFields = targetFieldsCache.get(targetClass);
        if (targetFields == null) {
            for (Field targetField : targetFields = ReflectUtil.getFieldArrayIncludeSupClassExcludeUID(targetClass)) {
                targetField.setAccessible(true);
            }
            targetFieldsCache.put(targetClass, targetFields);
        }
        OriginFieldsCache originCache = originFieldsCache.get(originObject.getClass());
        boolean useCache = true;
        if (originCache == null) {
            originCache = new OriginFieldsCache();
            useCache = false;
            originFieldsCache.put(originObject.getClass(), originCache);
        }
        Object originValue = null;
        for (Field targetField : targetFields) {
            Field originField;
            String fieldName = targetField.getName();
            if (useCache) {
                originField = originCache.getField(fieldName);
                if (originField == null && (originField = ReflectUtil.getField(originObject.getClass(), fieldName)) != null) {
                    originCache.addField(fieldName, originField);
                }
            } else {
                originField = ReflectUtil.getField(originObject.getClass(), fieldName);
                if (originField != null) {
                    originCache.addField(fieldName, originField);
                }
            }
            if (originField == null || Modifier.isStatic(originField.getModifiers())) continue;
            try {
                originValue = originField.get(originObject);
                if (originValue == null) {
                    continue;
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            Object targetValue = ValueCast.cast(targetField, targetObject, originValue);
            if (targetValue == null) continue;
            try {
                targetField.set(targetObject, targetValue);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return targetObject;
    }
}

