/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.core.reflect.copier;

import com.thankjava.toolkit.core.reflect.BeanCopierUtil;
import com.thankjava.toolkit.core.reflect.copier.TypeSort;
import com.thankjava.toolkit.core.reflect.copier.ValueFactory;
import java.lang.reflect.Field;

public class ValueCast {
    public static Object cast(Field targetField, Object targetObject, Object originValue) {
        return ValueCast.createValue(targetField, targetField.getType(), targetObject, originValue);
    }

    static Object createValue(Field targetField, Class<?> targetFieldType, Object targetObject, Object originValue) {
        switch (TypeSort.sortType(targetFieldType)) {
            case JDK_BASE: {
                return originValue;
            }
            case JDK_ARRAY: {
                return ValueFactory.createValueArray(targetField, targetFieldType, targetObject, originValue);
            }
            case JDK_ENUM: {
                return ValueFactory.createValueEnum(targetField, targetFieldType, targetObject, originValue);
            }
            case JDK_LIST: {
                return ValueFactory.createValueList(targetField, targetFieldType, targetObject, originValue);
            }
            case JDK_MAP: {
                return ValueFactory.createValueMap(targetField, targetFieldType, targetObject, originValue);
            }
        }
        return BeanCopierUtil.copy(originValue, targetFieldType);
    }
}

