/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.core.reflect.copier;

import com.thankjava.toolkit.core.reflect.ReflectUtil;
import com.thankjava.toolkit.core.reflect.copier.ValueCast;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class ValueFactory {
    ValueFactory() {
    }

    static Object createValueArray(Field targetField, Class<?> targetFieldType, Object targetObject, Object originValue) {
        if (originValue == null) {
            return null;
        }
        Class<?> proxyType = targetFieldType.getComponentType();
        Object[] originArray = (Object[])originValue;
        if (originArray.length == 0) {
            return null;
        }
        Object[] targetArray = (Object[])Array.newInstance(proxyType, originArray.length);
        for (int i = 0; i < originArray.length; ++i) {
            targetArray[i] = ValueCast.createValue(targetField, proxyType, targetObject, originArray[i]);
        }
        return targetArray;
    }

    static Object createValueEnum(Field targetField, Class<?> targetFieldType, Object targetObject, Object originValue) {
        if (originValue == null) {
            return null;
        }
        Object enumNameObj = ReflectUtil.getFieldVal(originValue, "name");
        if (enumNameObj == null) {
            return null;
        }
        String enumName = (String)enumNameObj;
        return Enum.valueOf(targetFieldType, enumName);
    }

    static Object createValueList(Field targetField, Class<?> targetFieldType, Object targetObject, Object originValue) {
        if (originValue == null) {
            return null;
        }
        List originList = (List)originValue;
        if (originList.size() == 0) {
            return null;
        }
        Type type = targetField.getGenericType();
        Object actualTypeArguments = ReflectUtil.getFieldVal(type, "actualTypeArguments");
        Type[] actualType = (Type[])actualTypeArguments;
        if (actualType.length > 0) {
            if (!(actualType[0] instanceof Class)) {
                return originList;
            }
        } else {
            return null;
        }
        Class proxyType = (Class)actualType[0];
        ArrayList<Object> targetList = new ArrayList<Object>();
        for (Object object : originList) {
            targetList.add(ValueCast.createValue(targetField, proxyType, targetList, object));
        }
        return targetList;
    }

    static Object createValueMap(Field targetField, Class<?> targetFieldType, Object targetObject, Object originValue) {
        if (originValue == null) {
            return null;
        }
        Map originMap = (Map)originValue;
        if (originMap.size() == 0) {
            return null;
        }
        Class<?> keyClass = null;
        Class<?> valueClass = null;
        Iterator iterator = originMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            keyClass = entry.getKey().getClass();
            valueClass = entry.getValue().getClass();
        }
        HashMap<Object, Object> targetMap = new HashMap<Object, Object>();
        for (Map.Entry entry : originMap.entrySet()) {
            targetMap.put(ValueCast.createValue(targetField, keyClass, targetObject, entry.getKey()), ValueCast.createValue(targetField, valueClass, targetObject, entry.getValue()));
        }
        return targetMap;
    }
}

