/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.core.thread;

import com.thankjava.toolkit.bean.thread.TaskEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class ThreadTask {
    private ScheduledExecutorService scheduledExecutorService;
    private ConcurrentHashMap<String, ScheduledFuture<?>> runningTask = new ConcurrentHashMap();

    public ThreadTask(int poolSize) {
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(poolSize, new ThreadFactory(){
            private final AtomicInteger poolNumber = new AtomicInteger(1);
            private final AtomicInteger threadNumber = new AtomicInteger(1);
            SecurityManager s = System.getSecurityManager();
            private final ThreadGroup group = this.s != null ? this.s.getThreadGroup() : Thread.currentThread().getThreadGroup();

            @Override
            public Thread newThread(Runnable runnable) {
                String DEFAULT_THREAD_NAME = "toolkit.Task";
                String DEFAULT_THREAD_GROUP_NAME = "toolkit.Task-Group";
                String namePrefix = DEFAULT_THREAD_GROUP_NAME + " " + this.poolNumber.getAndIncrement() + " ; " + DEFAULT_THREAD_NAME;
                Thread thread = new Thread(this.group, runnable, namePrefix + " " + this.threadNumber.getAndIncrement(), 0L);
                if (thread.isDaemon()) {
                    thread.setDaemon(false);
                }
                if (thread.getPriority() != 5) {
                    thread.setPriority(5);
                }
                return thread;
            }
        });
    }

    public void addTaskAtFixedRate(TaskEntity taskEntity) {
        ScheduledFuture<?> future = this.scheduledExecutorService.scheduleAtFixedRate(taskEntity.getRunnable(), taskEntity.getStartDelayTime(), taskEntity.getTimeInterval(), TimeUnit.SECONDS);
        this.runningTask.put(taskEntity.getTaskId(), future);
    }

    public void addTaskAtFixedRate(List<TaskEntity> taskEntities) {
        for (TaskEntity taskEntity : taskEntities) {
            ScheduledFuture<?> future = this.scheduledExecutorService.scheduleAtFixedRate(taskEntity.getRunnable(), taskEntity.getStartDelayTime(), taskEntity.getTimeInterval(), TimeUnit.SECONDS);
            this.runningTask.put(taskEntity.getTaskId(), future);
        }
    }

    public void addTaskWithFixedDelay(TaskEntity taskEntity) {
        ScheduledFuture<?> future = this.scheduledExecutorService.scheduleWithFixedDelay(taskEntity.getRunnable(), taskEntity.getStartDelayTime(), taskEntity.getTimeInterval(), TimeUnit.SECONDS);
        this.runningTask.put(taskEntity.getTaskId(), future);
    }

    public void addTaskWithFixedDelay(List<TaskEntity> taskEntities) {
        for (TaskEntity taskEntity : taskEntities) {
            ScheduledFuture<?> future = this.scheduledExecutorService.scheduleWithFixedDelay(taskEntity.getRunnable(), taskEntity.getStartDelayTime(), taskEntity.getTimeInterval(), TimeUnit.SECONDS);
            this.runningTask.put(taskEntity.getTaskId(), future);
        }
    }

    public void addTaskRunOnce(int startDelayTime, Runnable runnable) {
        this.scheduledExecutorService.schedule(runnable, (long)startDelayTime, TimeUnit.SECONDS);
    }

    public boolean removeTaskByTaskId(String taskId, boolean isForce) {
        ScheduledFuture<?> future = this.runningTask.get(taskId);
        boolean flag = future.cancel(isForce);
        if (flag) {
            this.runningTask.remove(taskId);
        }
        return flag;
    }

    public int getRunningTaskCount() {
        return this.runningTask.size();
    }

    public void clearAllTasks(boolean isForce) {
        ArrayList<String> taskIds = new ArrayList<String>();
        for (Map.Entry<String, ScheduledFuture<?>> tasks : this.runningTask.entrySet()) {
            ScheduledFuture<?> future = this.runningTask.get(tasks.getKey());
            boolean flag = future.cancel(isForce);
            if (!flag) continue;
            taskIds.add(tasks.getKey());
        }
        for (String taskId : taskIds) {
            this.runningTask.remove(taskId);
        }
    }

    public void shutdown(boolean isForce) {
        if (this.scheduledExecutorService != null) {
            if (isForce) {
                this.scheduledExecutorService.shutdownNow();
            }
            this.scheduledExecutorService.shutdown();
        }
    }
}

